"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.memory = void 0;
var _constants = require("../../../shared/charts/constants");
var _formulas = require("../formulas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const dockerContainerMemoryUsageXY = {
  id: 'memoryUsage',
  chartType: 'xy',
  title: _constants.MEMORY_USAGE_LABEL,
  layers: [{
    seriesType: 'line',
    type: 'series',
    xAxis: '@timestamp',
    yAxis: [_formulas.formulas.dockerContainerMemoryUsage]
  }],
  ..._constants.DEFAULT_XY_FITTING_FUNCTION,
  ..._constants.DEFAULT_XY_HIDDEN_LEGEND,
  ..._constants.DEFAULT_XY_YBOUNDS,
  ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE
};
const k8sContainerMemoryUsageXY = {
  id: 'k8sMemoryUsage',
  chartType: 'xy',
  title: _constants.MEMORY_USAGE_LABEL,
  layers: [{
    seriesType: 'line',
    type: 'series',
    xAxis: '@timestamp',
    yAxis: [_formulas.formulas.k8sContainerMemoryUsage]
  }],
  ..._constants.DEFAULT_XY_FITTING_FUNCTION,
  ..._constants.DEFAULT_XY_HIDDEN_LEGEND,
  ..._constants.DEFAULT_XY_YBOUNDS,
  ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE
};
const dockerContainerMemoryUsageMetric = {
  id: 'memoryUsage',
  chartType: 'metric',
  title: _constants.MEMORY_USAGE_LABEL,
  trendLine: true,
  ..._formulas.formulas.dockerContainerMemoryUsage
};
const k8sContainerMemoryUsageMetric = {
  id: 'k8sMemoryUsage',
  chartType: 'metric',
  title: _constants.MEMORY_USAGE_LABEL,
  trendLine: true,
  ..._formulas.formulas.k8sContainerMemoryUsage
};
const memory = exports.memory = {
  xy: {
    dockerContainerMemoryUsage: dockerContainerMemoryUsageXY,
    k8sContainerMemoryUsage: k8sContainerMemoryUsageXY
  },
  metric: {
    dockerContainerMemoryUsage: dockerContainerMemoryUsageMetric,
    k8sContainerMemoryUsage: k8sContainerMemoryUsageMetric
  }
};