"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSourceInstance = createSourceInstance;
var _source_registry = require("./source_registry");
var _setup_sources = require("./setup_sources");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

(0, _setup_sources.setupSources)();
function createSourceInstance(sourceDescriptor) {
  if (sourceDescriptor === null) {
    throw new Error('Source-descriptor should be initialized');
  }
  const source = (0, _source_registry.getSourceByType)(sourceDescriptor.type);
  if (!source) {
    throw new Error(`Unrecognized sourceType ${sourceDescriptor.type}`);
  }
  return new source.ConstructorFunction(sourceDescriptor);
}