"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMonospaceTextStyle = exports.useMeasuredCharacterDimensions = exports.unwrappedContentStyle = exports.preWrappedContentStyle = exports.longWrappedContentStyle = exports.hoveredContentStyle = exports.highlightedContentStyle = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _eui = require("@elastic/eui");
var _with_attrs = require("../../../utils/theme_utils/with_attrs");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFontSize = textscale => {
  switch (textscale) {
    case 'large':
      return 'm';
    case 'medium':
      return 's';
    case 'small':
      return 'xs';
    default:
      return 's';
  }
};
const useMonospaceTextStyle = (scale, euiTheme) => (0, _react2.css)`
  font-family: ${euiTheme.font.familyCode};
  font-size: ${(0, _eui.useEuiFontSize)(getFontSize(scale))};
  line-height: ${euiTheme.font.lineHeightMultiplier};
`;
exports.useMonospaceTextStyle = useMonospaceTextStyle;
const hoveredContentStyle = euiTheme => (0, _react2.css)`
  background-color: ${euiTheme.focus.backgroundColor};
`;
exports.hoveredContentStyle = hoveredContentStyle;
const highlightedContentStyle = euiTheme => (0, _react2.css)`
  background-color: ${euiTheme.colors.highlight};
`;
exports.highlightedContentStyle = highlightedContentStyle;
const longWrappedContentStyle = exports.longWrappedContentStyle = (0, _react2.css)`
  overflow: visible;
  white-space: pre-wrap;
  word-break: break-all;
`;
const preWrappedContentStyle = exports.preWrappedContentStyle = (0, _react2.css)`
  overflow: hidden;
  white-space: pre;
`;
const unwrappedContentStyle = exports.unwrappedContentStyle = (0, _react2.css)`
  overflow: hidden;
  white-space: nowrap;
`;
const useMeasuredCharacterDimensions = scale => {
  const [dimensions, setDimensions] = (0, _react.useState)({
    height: 0,
    width: 0
  });
  const measureElement = (0, _react.useCallback)(element => {
    if (!element) {
      return;
    }
    const boundingBox = element.getBoundingClientRect();
    setDimensions({
      height: boundingBox.height,
      width: boundingBox.width
    });
  }, []);
  const CharacterDimensionsProbe = (0, _react.useMemo)(() => () => /*#__PURE__*/_react.default.createElement(MonospaceCharacterDimensionsProbe, {
    scale: scale,
    ref: measureElement
  }, "X"), [measureElement, scale]);
  return {
    CharacterDimensionsProbe,
    dimensions
  };
};
exports.useMeasuredCharacterDimensions = useMeasuredCharacterDimensions;
const MonospaceCharacterDimensionsProbe = (0, _with_attrs.withAttrs)(_styled.default.div`
    visibility: hidden;
    position: absolute;
    height: auto;
    width: auto;
    padding: 0;
    margin: 0;

    ${props => useMonospaceTextStyle(props.scale, props.theme.euiTheme)};
  `, () => ({
  'aria-hidden': true
}));