"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LensTopNavMenu = void 0;
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _esQuery = require("@kbn/es-query");
var _reactRedux = require("react-redux");
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _managedContentBadge = require("@kbn/managed-content-badge");
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _deeplinksAnalytics = require("@kbn/deeplinks-analytics");
var _constants = require("../../common/constants");
var _settings_menu = require("./settings_menu");
var _state_management = require("../state_management");
var _utils = require("../utils");
var _show_underlying_data = require("./show_underlying_data");
var _lens_slice = require("../state_management/lens_slice");
var _share_action = require("./share_action");
var _utils2 = require("../state_management/utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getSaveButtonMeta({
  contextFromEmbeddable,
  showSaveAndReturn,
  showReplaceInDashboard,
  showReplaceInCanvas
}) {
  if (showSaveAndReturn) {
    return {
      label: contextFromEmbeddable ? _i18n.i18n.translate('xpack.lens.app.saveAndReplace', {
        defaultMessage: 'Save and replace'
      }) : _i18n.i18n.translate('xpack.lens.app.saveAndReturn', {
        defaultMessage: 'Save and return'
      }),
      emphasize: true,
      iconType: contextFromEmbeddable ? 'save' : 'checkInCircleFilled',
      testId: 'lnsApp_saveAndReturnButton',
      description: _i18n.i18n.translate('xpack.lens.app.saveAndReturnButtonAriaLabel', {
        defaultMessage: 'Save the current lens visualization and return to the last app'
      })
    };
  }
  if (showReplaceInDashboard) {
    return {
      label: _i18n.i18n.translate('xpack.lens.app.replaceInDashboard', {
        defaultMessage: 'Replace in dashboard'
      }),
      emphasize: true,
      iconType: 'merge',
      testId: 'lnsApp_replaceInDashboardButton',
      description: _i18n.i18n.translate('xpack.lens.app.replaceInDashboardButtonAriaLabel', {
        defaultMessage: 'Replace legacy visualization with lens visualization and return to the dashboard'
      })
    };
  }
  if (showReplaceInCanvas) {
    return {
      label: _i18n.i18n.translate('xpack.lens.app.replaceInCanvas', {
        defaultMessage: 'Replace in canvas'
      }),
      emphasize: true,
      iconType: 'merge',
      testId: 'lnsApp_replaceInCanvasButton',
      description: _i18n.i18n.translate('xpack.lens.app.replaceInCanvasButtonAriaLabel', {
        defaultMessage: 'Replace legacy visualization with lens visualization and return to the canvas'
      })
    };
  }
}
const navItemWithDividerStyles = euiThemeContext => (0, _react2.css)`
  ${(0, _eui.euiBreakpoint)(euiThemeContext, ['m', 'l', 'xl'])} {
    margin-right: ${euiThemeContext.euiTheme.size.m};
    position: relative;
    &:after {
      border-right: ${euiThemeContext.euiTheme.border.thin};
      bottom: 0;
      content: '';
      display: block;
      pointer-events: none;
      position: absolute;
      right: -${euiThemeContext.euiTheme.size.s};
      top: 0;
    }
  }
`;
function getLensTopNavConfig(options) {
  const {
    actions,
    savingToLibraryPermitted,
    savingToDashboardPermitted,
    contextOriginatingApp,
    showReplaceInDashboard,
    showReplaceInCanvas,
    contextFromEmbeddable,
    isByValueMode
  } = options;
  const topNavMenu = [];
  const showSaveAndReturn = actions.saveAndReturn.visible;
  const enableSaveButton = savingToLibraryPermitted || savingToDashboardPermitted && !isByValueMode && !showSaveAndReturn;
  const saveButtonLabel = isByValueMode ? _i18n.i18n.translate('xpack.lens.app.addToLibrary', {
    defaultMessage: 'Save to library'
  }) : actions.saveAndReturn.visible ? _i18n.i18n.translate('xpack.lens.app.saveAs', {
    defaultMessage: 'Save as'
  }) : _i18n.i18n.translate('xpack.lens.app.save', {
    defaultMessage: 'Save'
  });
  if (contextOriginatingApp && !actions.cancel.visible) {
    topNavMenu.push({
      label: _i18n.i18n.translate('xpack.lens.app.goBackLabel', {
        defaultMessage: `Go back to {contextOriginatingApp}`,
        values: {
          contextOriginatingApp
        }
      }),
      run: actions.goBack.execute,
      testId: 'lnsApp_goBackToAppButton',
      description: _i18n.i18n.translate('xpack.lens.app.goBackLabel', {
        defaultMessage: `Go back to {contextOriginatingApp}`,
        values: {
          contextOriginatingApp
        }
      }),
      disableButton: !actions.goBack.enabled,
      css: navItemWithDividerStyles
    });
  }
  if (actions.getUnderlyingDataUrl.visible) {
    var _actions$getUnderlyin, _actions$getUnderlyin2;
    const exploreDataInDiscoverLabel = _i18n.i18n.translate('xpack.lens.app.exploreDataInDiscover', {
      defaultMessage: 'Explore in Discover'
    });
    topNavMenu.push({
      label: exploreDataInDiscoverLabel,
      run: actions.getUnderlyingDataUrl.execute,
      testId: 'lnsApp_openInDiscover',
      description: exploreDataInDiscoverLabel,
      disableButton: !actions.getUnderlyingDataUrl.enabled,
      tooltip: actions.getUnderlyingDataUrl.tooltip,
      target: '_blank',
      href: (_actions$getUnderlyin = (_actions$getUnderlyin2 = actions.getUnderlyingDataUrl).getLink) === null || _actions$getUnderlyin === void 0 ? void 0 : _actions$getUnderlyin.call(_actions$getUnderlyin2),
      css: navItemWithDividerStyles
    });
  }
  topNavMenu.push({
    label: _i18n.i18n.translate('xpack.lens.app.inspect', {
      defaultMessage: 'Inspect'
    }),
    run: actions.inspect.execute,
    testId: 'lnsApp_inspectButton',
    description: _i18n.i18n.translate('xpack.lens.app.inspectAriaLabel', {
      defaultMessage: 'inspect'
    }),
    disableButton: false
  });
  if (actions.export.visible) {
    topNavMenu.push({
      label: _i18n.i18n.translate('xpack.lens.app.shareTitle', {
        defaultMessage: 'Export'
      }),
      iconType: 'download',
      iconOnly: true,
      run: actions.export.execute,
      testId: 'lnsApp_exportButton',
      description: _i18n.i18n.translate('xpack.lens.app.shareTitleAria', {
        defaultMessage: 'Export visualization'
      }),
      disableButton: !actions.export.enabled,
      tooltip: actions.export.tooltip
    });
  }
  if (actions.share.visible) {
    topNavMenu.push({
      label: _i18n.i18n.translate('xpack.lens.app.shareTitle', {
        defaultMessage: 'Share'
      }),
      iconType: 'share',
      iconOnly: true,
      run: actions.share.execute,
      testId: 'lnsApp_shareButton',
      description: _i18n.i18n.translate('xpack.lens.app.shareTitleAria', {
        defaultMessage: 'Share visualization'
      }),
      disableButton: !actions.share.enabled,
      tooltip: actions.share.tooltip
    });
  }
  topNavMenu.push({
    label: _i18n.i18n.translate('xpack.lens.app.settings', {
      defaultMessage: 'Settings'
    }),
    run: actions.openSettings.execute,
    testId: 'lnsApp_settingsButton',
    description: _i18n.i18n.translate('xpack.lens.app.settingsAriaLabel', {
      defaultMessage: 'Open the Lens settings menu'
    }),
    css: navItemWithDividerStyles
  });
  if (actions.cancel.visible) {
    topNavMenu.push({
      label: _i18n.i18n.translate('xpack.lens.app.cancel', {
        defaultMessage: 'Cancel'
      }),
      run: actions.cancel.execute,
      testId: 'lnsApp_cancelButton',
      description: _i18n.i18n.translate('xpack.lens.app.cancelButtonAriaLabel', {
        defaultMessage: 'Return to the last app without saving changes'
      })
    });
  }
  topNavMenu.push({
    label: saveButtonLabel,
    iconType: (showReplaceInDashboard || showReplaceInCanvas ? false : !showSaveAndReturn) ? 'save' : undefined,
    emphasize: showReplaceInDashboard || showReplaceInCanvas ? false : !showSaveAndReturn,
    run: actions.showSaveModal.execute,
    testId: 'lnsApp_saveButton',
    description: _i18n.i18n.translate('xpack.lens.app.saveButtonAriaLabel', {
      defaultMessage: 'Save the current lens visualization'
    }),
    disableButton: !enableSaveButton
  });
  const saveButtonMeta = getSaveButtonMeta({
    showSaveAndReturn,
    showReplaceInDashboard,
    showReplaceInCanvas,
    contextFromEmbeddable
  });
  if (saveButtonMeta) {
    topNavMenu.push({
      ...saveButtonMeta,
      run: actions.saveAndReturn.execute,
      disableButton: !actions.saveAndReturn.enabled
    });
  }
  return topNavMenu;
}
const LensTopNavMenu = ({
  setHeaderActionMenu,
  initialInput,
  indicateNoData,
  lensInspector,
  setIsSaveModalVisible,
  getIsByValueMode,
  runSave,
  onAppLeave,
  redirectToOrigin,
  datasourceMap,
  visualizationMap,
  title,
  goBackToOriginatingApp,
  contextOriginatingApp,
  initialContextIsEmbedded,
  topNavMenuEntryGenerators,
  initialContext,
  indexPatternService,
  currentDoc,
  getUserMessages,
  shortUrlService,
  isCurrentStateDirty,
  startServices
}) => {
  var _application$capabili, _currentIndexPattern$;
  const {
    data,
    navigation,
    uiSettings,
    application,
    share,
    dataViewFieldEditor,
    dataViewEditor,
    dataViews: dataViewsService
  } = (0, _public2.useKibana)().services;
  const {
    isSaveable,
    isLinkedToOriginatingApp,
    query,
    activeData,
    savedQuery,
    activeDatasourceId,
    datasourceStates,
    visualization,
    filters,
    dataViews
  } = (0, _state_management.useLensSelector)(state => state.lens);
  const dispatch = (0, _state_management.useLensDispatch)();
  const dispatchSetState = _react.default.useCallback(state => dispatch((0, _state_management.setState)(state)), [dispatch]);
  const [indexPatterns, setIndexPatterns] = (0, _react.useState)([]);
  const [currentIndexPattern, setCurrentIndexPattern] = (0, _react.useState)();
  const isOnTextBasedMode = query != null && typeof query === 'object' && (0, _esQuery.isOfAggregateQueryType)(query);
  const [rejectedIndexPatterns, setRejectedIndexPatterns] = (0, _react.useState)([]);
  const dispatchChangeIndexPattern = _react.default.useCallback(async dataViewOrId => {
    const indexPatternId = typeof dataViewOrId === 'string' ? dataViewOrId : dataViewOrId.id;
    const newIndexPatterns = await indexPatternService.ensureIndexPattern({
      id: indexPatternId,
      cache: dataViews.indexPatterns
    });
    dispatch((0, _lens_slice.changeIndexPattern)({
      dataViews: {
        indexPatterns: newIndexPatterns
      },
      datasourceIds: Object.keys(datasourceStates),
      visualizationIds: visualization.activeId ? [visualization.activeId] : [],
      indexPatternId
    }));
  }, [dataViews.indexPatterns, datasourceStates, dispatch, indexPatternService, visualization.activeId]);
  const canEditDataView = Boolean(dataViewEditor === null || dataViewEditor === void 0 ? void 0 : dataViewEditor.userPermissions.editDataView()) || !(currentIndexPattern !== null && currentIndexPattern !== void 0 && currentIndexPattern.isPersisted());
  const closeFieldEditor = (0, _react.useRef)();
  const closeDataViewEditor = (0, _react.useRef)();
  const allLoaded = Object.values(datasourceStates).every(({
    isLoading
  }) => isLoading === false);
  (0, _react.useEffect)(() => {
    const activeDatasource = datasourceMap && activeDatasourceId && !datasourceStates[activeDatasourceId].isLoading ? datasourceMap[activeDatasourceId] : undefined;
    if (!activeDatasource) {
      return;
    }
    const indexPatternIds = new Set((0, _utils.getIndexPatternsIds)({
      activeDatasourceId,
      activeDatasources: Object.keys(datasourceStates).reduce((acc, datasourceId) => ({
        ...acc,
        [datasourceId]: datasourceMap[datasourceId]
      }), {}),
      datasourceStates,
      visualizationState: visualization.state,
      activeVisualization: visualization.activeId ? visualizationMap[visualization.activeId] : undefined
    }));
    // Add ad-hoc data views from the Lens state even if they are not used
    Object.values(dataViews.indexPatterns).filter(indexPattern => !indexPattern.isPersisted).forEach(indexPattern => {
      indexPatternIds.add(indexPattern.id);
    });
    const hasIndexPatternsChanged = indexPatterns.length + rejectedIndexPatterns.length !== indexPatternIds.size || [...indexPatternIds].some(id => !indexPatterns.map(ip => ip.id).concat(rejectedIndexPatterns).some(loadedId => loadedId === id));

    // Update the cached index patterns if the user made a change to any of them
    if (hasIndexPatternsChanged) {
      (0, _utils.getIndexPatternsObjects)([...indexPatternIds], dataViewsService).then(({
        indexPatterns: indexPatternObjects,
        rejectedIds
      }) => {
        setIndexPatterns(indexPatternObjects);
        setRejectedIndexPatterns(rejectedIds);
      });
    }
  }, [datasourceStates, activeDatasourceId, rejectedIndexPatterns, datasourceMap, visualizationMap, visualization, indexPatterns, dataViewsService, dataViews]);
  (0, _react.useEffect)(() => {
    const setCurrentPattern = async () => {
      if (activeDatasourceId && datasourceStates[activeDatasourceId].state) {
        const dataViewId = datasourceMap[activeDatasourceId].getUsedDataView(datasourceStates[activeDatasourceId].state);
        const dataView = dataViewId ? await data.dataViews.get(dataViewId) : undefined;
        setCurrentIndexPattern(dataView !== null && dataView !== void 0 ? dataView : indexPatterns[0]);
      }
    };
    setCurrentPattern();
  }, [activeDatasourceId, datasourceMap, datasourceStates, indexPatterns, data.dataViews, isOnTextBasedMode]);
  const hasShareIntegration = (0, _react.useMemo)(() => {
    if (!share) return false;
    return share.availableIntegrations('lens', 'export').length > 0;
  }, [share]);
  (0, _react.useEffect)(() => {
    return () => {
      var _closeFieldEditor$cur, _closeDataViewEditor$;
      // Make sure to close the editors when unmounting
      (_closeFieldEditor$cur = closeFieldEditor.current) === null || _closeFieldEditor$cur === void 0 ? void 0 : _closeFieldEditor$cur.call(closeFieldEditor);
      (_closeDataViewEditor$ = closeDataViewEditor.current) === null || _closeDataViewEditor$ === void 0 ? void 0 : _closeDataViewEditor$.call(closeDataViewEditor);
    };
  }, []);
  const {
    AggregateQueryTopNavMenu
  } = navigation.ui;
  const {
    from,
    to
  } = data.query.timefilter.timefilter.getTime();
  const savingToLibraryPermitted = Boolean(isSaveable && application.capabilities.visualize_v2.save);
  const savingToDashboardPermitted = Boolean(isSaveable && ((_application$capabili = application.capabilities.dashboard_v2) === null || _application$capabili === void 0 ? void 0 : _application$capabili.showWriteControls));
  const defaultLensTitle = _i18n.i18n.translate('xpack.lens.app.share.defaultDashboardTitle', {
    defaultMessage: 'Lens Visualization [{date}]',
    values: {
      date: (0, _moment.default)().toISOString(true)
    }
  });
  const additionalMenuEntries = (0, _react.useMemo)(() => {
    if (!visualization.activeId) return undefined;
    const visualizationId = visualization.activeId;
    const entries = topNavMenuEntryGenerators.flatMap(menuEntryGenerator => {
      const menuEntry = menuEntryGenerator({
        datasourceStates,
        visualizationId,
        visualizationState: visualization.state,
        query,
        filters,
        initialContext,
        currentDoc
      });
      return menuEntry ? [menuEntry] : [];
    });
    if (entries.length > 0) {
      return entries;
    }
  }, [datasourceStates, topNavMenuEntryGenerators, visualization.activeId, visualization.state, query, filters, initialContext, currentDoc]);
  const discoverLocator = share === null || share === void 0 ? void 0 : share.url.locators.get('DISCOVER_APP_LOCATOR');
  const layerMetaInfo = (0, _react.useMemo)(() => {
    if (!activeDatasourceId || !discoverLocator) {
      return;
    }
    if (visualization.activeId == null) {
      return;
    }
    return (0, _show_underlying_data.getLayerMetaInfo)(datasourceMap[activeDatasourceId], datasourceStates[activeDatasourceId].state, visualizationMap[visualization.activeId], visualization.state, activeData, dataViews.indexPatterns, data.query.timefilter.timefilter.getTime(), application.capabilities);
  }, [activeDatasourceId, discoverLocator, visualization, datasourceMap, datasourceStates, visualizationMap, activeData, dataViews.indexPatterns, data.query.timefilter.timefilter, application.capabilities]);
  const lensStore = (0, _reactRedux.useStore)();
  const adHocDataViews = indexPatterns.filter(pattern => !pattern.isPersisted());
  const topNavConfig = (0, _react.useMemo)(() => {
    const showReplaceInDashboard = (initialContext === null || initialContext === void 0 ? void 0 : initialContext.originatingApp) === 'dashboards' && !(initialInput !== null && initialInput !== void 0 && initialInput.savedObjectId);
    const showReplaceInCanvas = (initialContext === null || initialContext === void 0 ? void 0 : initialContext.originatingApp) === 'canvas' && !(initialInput !== null && initialInput !== void 0 && initialInput.savedObjectId);
    const contextFromEmbeddable = initialContext && 'isEmbeddable' in initialContext && initialContext.isEmbeddable;
    const showSaveAndReturn = !(showReplaceInDashboard || showReplaceInCanvas) && (isLinkedToOriginatingApp || Boolean(initialContextIsEmbedded));
    const hasData = Boolean(activeData && Object.keys(activeData).length);
    const csvEnabled = Boolean(isSaveable && hasData);
    const shareUrlEnabled = Boolean(application.capabilities.visualize_v2.createShortUrl && hasData);
    const showShareMenu = csvEnabled || shareUrlEnabled;
    const shareExecutor = async (anchorElement, asExport) => {
      var _activeVisualization$, _activeVisualization$2, _activeVisualization$3, _activeVisualization$4;
      if (!share) {
        return;
      }
      if (visualization.activeId == null || !visualizationMap[visualization.activeId]) {
        return;
      }
      const activeVisualization = visualizationMap[visualization.activeId];
      const configuration = {
        filters,
        query,
        activeDatasourceId,
        datasourceStates,
        datasourceMap,
        visualizationMap,
        visualization,
        currentDoc,
        adHocDataViews: adHocDataViews.map(dataView => dataView.toSpec())
      };
      const {
        shareURL: shareLocatorParams,
        reporting: reportingLocatorParams
      } = (0, _share_action.getLocatorParams)(data, configuration, isCurrentStateDirty);
      const datasourceLayers = (0, _utils2.getDatasourceLayers)(datasourceStates, datasourceMap, dataViews.indexPatterns);
      const exportDatatables = (_activeVisualization$ = (_activeVisualization$2 = activeVisualization.getExportDatatables) === null || _activeVisualization$2 === void 0 ? void 0 : _activeVisualization$2.call(activeVisualization, visualization.state, datasourceLayers, activeData)) !== null && _activeVisualization$ !== void 0 ? _activeVisualization$ : [];
      const datatables = exportDatatables.length > 0 ? exportDatatables : Object.values(activeData !== null && activeData !== void 0 ? activeData : {});
      const sharingData = {
        datatables,
        csvEnabled,
        reportingDisabled: !csvEnabled,
        title: title || defaultLensTitle,
        locatorParams: {
          id: _deeplinksAnalytics.LENS_APP_LOCATOR,
          params: reportingLocatorParams
        },
        layout: {
          dimensions: (_activeVisualization$3 = (_activeVisualization$4 = activeVisualization.getReportingLayout) === null || _activeVisualization$4 === void 0 ? void 0 : _activeVisualization$4.call(activeVisualization, visualization.state)) !== null && _activeVisualization$3 !== void 0 ? _activeVisualization$3 : _share_action.DEFAULT_LENS_LAYOUT_DIMENSIONS
        }
      };
      share.toggleShareContextMenu({
        asExport,
        anchorElement,
        allowShortUrl: false,
        objectId: currentDoc === null || currentDoc === void 0 ? void 0 : currentDoc.savedObjectId,
        objectType: 'lens',
        objectTypeMeta: {
          title: _i18n.i18n.translate('xpack.lens.app.shareModal.title', {
            defaultMessage: 'Share this Lens visualization'
          }),
          config: {
            link: {
              draftModeCallOut: /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
                color: "warning",
                title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
                  id: "xpack.lens.app.shareModal.draftModeCallout.title",
                  defaultMessage: "Unsaved changes"
                })
              }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
                id: "xpack.lens.app.shareModal.draftModeCallout.link.warning",
                defaultMessage: "The copied link resolves to the current state of this visualization. To get a permanent link, make sure to save your Lens visualization first."
              })),
              delegatedShareUrlHandler: async () => {
                const {
                  shareableUrl,
                  savedObjectURL
                } = (0, _share_action.getShareURL)(shortUrlService, shareLocatorParams, {
                  application,
                  data
                }, configuration, shareUrlEnabled, isCurrentStateDirty);
                return !(currentDoc !== null && currentDoc !== void 0 && currentDoc.savedObjectId) ? await shareableUrl : savedObjectURL.href;
              },
              // disable the menu if both shortURL permission and the visualization has not been saved
              // TODO: improve here the disabling state with more specific checks
              disabled: Boolean(!shareUrlEnabled && !(currentDoc !== null && currentDoc !== void 0 && currentDoc.savedObjectId))
            },
            embed: {
              disabled: true,
              showPublicUrlSwitch: () => false
            },
            integration: {
              export: {
                csvDownloadLens: {
                  draftModeCallOut: /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
                    color: "warning",
                    iconType: "warning",
                    title: _i18n.i18n.translate('xpack.lens.app.exports.csvDownloadLens.warning.title', {
                      defaultMessage: 'Unsaved changes'
                    })
                  }, _i18n.i18n.translate('xpack.lens.app.exports.csvDownloadLens.postURLWatcherMessage.unsavedChanges', {
                    defaultMessage: 'The copied link resolves to the current state of this visualization. To get a permanent link, make sure to save your Lens visualization first.'
                  }))
                },
                imageReports: {
                  draftModeCallOut: /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
                    color: "warning",
                    iconType: "warning",
                    title: _i18n.i18n.translate('xpack.lens.app.exports.imageReports.warning.title', {
                      defaultMessage: 'Unsaved changes'
                    })
                  }, _i18n.i18n.translate('xpack.lens.app.exports.imageReports.postURLWatcherMessage.unsavedChanges', {
                    defaultMessage: 'The copied link resolves to the current state of this visualization. To get a permanent link, make sure to save your Lens visualization first.'
                  }))
                },
                pdfReports: {
                  draftModeCallOut: /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
                    color: "warning",
                    iconType: "warning",
                    title: _i18n.i18n.translate('xpack.lens.app.exports.pdfReports.warning.title', {
                      defaultMessage: 'Unsaved changes'
                    })
                  }, _i18n.i18n.translate('xpack.lens.app.exports.pdfReports.postURLWatcherMessage.unsavedChanges', {
                    defaultMessage: 'The copied link resolves to the current state of this visualization. To get a permanent link, make sure to save your Lens visualization first.'
                  }))
                }
              }
            }
          }
        },
        sharingData,
        // only want to know about changes when savedObjectURL.href
        isDirty: isCurrentStateDirty || !(currentDoc !== null && currentDoc !== void 0 && currentDoc.savedObjectId),
        onClose: () => {
          anchorElement === null || anchorElement === void 0 ? void 0 : anchorElement.focus();
        }
      });
    };
    const baseMenuEntries = getLensTopNavConfig({
      isByValueMode: getIsByValueMode(),
      savingToLibraryPermitted,
      savingToDashboardPermitted,
      isSaveable,
      contextOriginatingApp,
      showReplaceInDashboard,
      showReplaceInCanvas,
      contextFromEmbeddable,
      actions: {
        inspect: {
          visible: true,
          execute: () => lensInspector.inspect({
            title
          })
        },
        export: {
          // Only show the export button if the current user meets the requirements for at least one registered export integration
          visible: hasShareIntegration,
          enabled: showShareMenu,
          tooltip: () => {
            if (!showShareMenu) {
              return _i18n.i18n.translate('xpack.lens.app.exportButtonDisabledWarning', {
                defaultMessage: 'The visualization has no data to export.'
              });
            }
          },
          execute: anchorElement => shareExecutor(anchorElement, true)
        },
        share: {
          visible: true,
          enabled: showShareMenu,
          tooltip: () => {
            if (!showShareMenu) {
              return _i18n.i18n.translate('xpack.lens.app.shareButtonDisabledWarning', {
                defaultMessage: 'The visualization has no data to share.'
              });
            }
          },
          execute: shareExecutor
        },
        saveAndReturn: {
          visible: showSaveAndReturn,
          enabled: isSaveable,
          execute: () => {
            if (isSaveable) {
              // disabling the validation on app leave because the document has been saved.
              onAppLeave(actions => {
                return actions.default();
              });
              runSave({
                newTitle: title || (contextFromEmbeddable ? _i18n.i18n.translate('xpack.lens.app.convertedLabel', {
                  defaultMessage: '{title} (converted)',
                  values: {
                    title: initialContext.title || `${initialContext.visTypeTitle} visualization`
                  }
                }) : ''),
                newCopyOnSave: false,
                isTitleDuplicateConfirmed: false,
                returnToOrigin: true,
                ...(contextFromEmbeddable && {
                  newDescription: initialContext.description
                }),
                panelTimeRange: contextFromEmbeddable ? initialContext.panelTimeRange : undefined
              }, {
                saveToLibrary: Boolean(initialInput === null || initialInput === void 0 ? void 0 : initialInput.savedObjectId)
              });
            }
          }
        },
        showSaveModal: {
          visible: Boolean(savingToDashboardPermitted || savingToLibraryPermitted),
          execute: () => {
            if (savingToDashboardPermitted || savingToLibraryPermitted) {
              setIsSaveModalVisible(true);
            }
          }
        },
        goBack: {
          visible: Boolean(contextOriginatingApp),
          enabled: Boolean(contextOriginatingApp),
          execute: () => {
            if (contextOriginatingApp) {
              goBackToOriginatingApp === null || goBackToOriginatingApp === void 0 ? void 0 : goBackToOriginatingApp();
            }
          }
        },
        cancel: {
          visible: Boolean(isLinkedToOriginatingApp),
          execute: () => {
            if (redirectToOrigin) {
              redirectToOrigin();
            }
          }
        },
        getUnderlyingDataUrl: {
          visible: Boolean(layerMetaInfo === null || layerMetaInfo === void 0 ? void 0 : layerMetaInfo.isVisible),
          enabled: !(layerMetaInfo !== null && layerMetaInfo !== void 0 && layerMetaInfo.error),
          tooltip: () => {
            return layerMetaInfo === null || layerMetaInfo === void 0 ? void 0 : layerMetaInfo.error;
          },
          execute: () => {},
          getLink: () => {
            var _dataViews$indexPatte;
            if (!layerMetaInfo) {
              return;
            }
            const {
              error,
              meta
            } = layerMetaInfo;
            // If Discover is not available, return
            // If there's no data, return
            if (error || !discoverLocator || !meta) {
              return;
            }
            const {
              filters: newFilters,
              query: newQuery
            } = (0, _show_underlying_data.combineQueryAndFilters)(query, filters, meta, indexPatterns, (0, _public.getEsQueryConfig)(uiSettings));
            return discoverLocator.getRedirectUrl({
              dataViewSpec: (_dataViews$indexPatte = dataViews.indexPatterns[meta.id]) === null || _dataViews$indexPatte === void 0 ? void 0 : _dataViews$indexPatte.spec,
              timeRange: data.query.timefilter.timefilter.getTime(),
              filters: newFilters,
              query: isOnTextBasedMode ? query : newQuery,
              columns: meta.columns
            });
          }
        },
        openSettings: {
          visible: true,
          execute: anchorElement => (0, _settings_menu.toggleSettingsMenuOpen)({
            lensStore,
            anchorElement,
            startServices
          })
        }
      }
    });
    return [...(additionalMenuEntries || []), ...baseMenuEntries];
  }, [initialContext, initialInput === null || initialInput === void 0 ? void 0 : initialInput.savedObjectId, isLinkedToOriginatingApp, initialContextIsEmbedded, activeData, isSaveable, application, getIsByValueMode, savingToLibraryPermitted, savingToDashboardPermitted, contextOriginatingApp, hasShareIntegration, layerMetaInfo, additionalMenuEntries, share, visualization, visualizationMap, filters, query, activeDatasourceId, datasourceStates, datasourceMap, currentDoc, adHocDataViews, data, isCurrentStateDirty, dataViews.indexPatterns, title, defaultLensTitle, shortUrlService, lensInspector, onAppLeave, runSave, setIsSaveModalVisible, goBackToOriginatingApp, redirectToOrigin, discoverLocator, indexPatterns, uiSettings, isOnTextBasedMode, lensStore, startServices]);
  const onQuerySubmitWrapped = (0, _react.useCallback)(payload => {
    const {
      dateRange,
      query: newQuery
    } = payload;
    const currentRange = data.query.timefilter.timefilter.getTime();
    if (dateRange.from !== currentRange.from || dateRange.to !== currentRange.to) {
      data.query.timefilter.timefilter.setTime(dateRange);
    } else {
      // Query has changed, renew the session id.
      // recalculate resolvedDateRange (relevant for relative time range)
      dispatchSetState({
        searchSessionId: data.search.session.start(),
        resolvedDateRange: (0, _utils.getResolvedDateRange)(data.query.timefilter.timefilter)
      });
    }
    if (newQuery) {
      if (!(0, _lodash.isEqual)(newQuery, query)) {
        dispatchSetState({
          query: newQuery
        });
        // check if query is text-based (esql etc) and switchAndCleanDatasource
        if ((0, _esQuery.isOfAggregateQueryType)(newQuery) && !isOnTextBasedMode) {
          dispatch((0, _state_management.switchAndCleanDatasource)({
            newDatasourceId: 'textBased',
            visualizationId: visualization === null || visualization === void 0 ? void 0 : visualization.activeId,
            currentIndexPatternId: currentIndexPattern === null || currentIndexPattern === void 0 ? void 0 : currentIndexPattern.id
          }));
        }
      }
    }
  }, [currentIndexPattern === null || currentIndexPattern === void 0 ? void 0 : currentIndexPattern.id, data.query.timefilter.timefilter, data.search.session, dispatch, dispatchSetState, isOnTextBasedMode, query, visualization === null || visualization === void 0 ? void 0 : visualization.activeId]);
  const onSavedWrapped = (0, _react.useCallback)(newSavedQuery => {
    dispatchSetState({
      savedQuery: newSavedQuery
    });
  }, [dispatchSetState]);
  const onSavedQueryUpdatedWrapped = (0, _react.useCallback)(newSavedQuery => {
    // If the user tries to load the same saved query that is already loaded,
    // we will receive the same object reference which was previously frozen
    // by Redux Toolkit. `filterManager.setFilters` will then try to modify
    // the query's filters, which will throw an error. To avoid this, we need
    // to clone the filters before passing them to `filterManager.setFilters`.
    const savedQueryFilters = structuredClone(newSavedQuery.attributes.filters || []);
    const globalFilters = data.query.filterManager.getGlobalFilters();
    data.query.filterManager.setFilters([...globalFilters, ...savedQueryFilters]);
    dispatchSetState({
      query: newSavedQuery.attributes.query,
      savedQuery: {
        ...newSavedQuery
      }
    }); // Shallow query for reference issues
  }, [data.query.filterManager, dispatchSetState]);
  const onClearSavedQueryWrapped = (0, _react.useCallback)(() => {
    data.query.filterManager.setFilters(data.query.filterManager.getGlobalFilters());
    dispatchSetState({
      filters: data.query.filterManager.getGlobalFilters(),
      query: data.query.queryString.getDefaultQuery(),
      savedQuery: undefined
    });
  }, [data.query.filterManager, data.query.queryString, dispatchSetState]);
  const refreshFieldList = (0, _react.useCallback)(async () => {
    if (currentIndexPattern !== null && currentIndexPattern !== void 0 && currentIndexPattern.id) {
      (0, _utils.refreshIndexPatternsList)({
        activeDatasources: Object.keys(datasourceStates).reduce((acc, datasourceId) => ({
          ...acc,
          [datasourceId]: datasourceMap[datasourceId]
        }), {}),
        indexPatternId: currentIndexPattern.id,
        indexPatternService,
        indexPatternsCache: dataViews.indexPatterns
      });
    }
    // start a new session so all charts are refreshed
    data.search.session.start();
  }, [currentIndexPattern, data.search.session, datasourceMap, datasourceStates, indexPatternService, dataViews.indexPatterns]);
  const editField = (0, _react.useMemo)(() => canEditDataView ? async (fieldName, _uiAction = 'edit') => {
    if (currentIndexPattern !== null && currentIndexPattern !== void 0 && currentIndexPattern.id) {
      const indexPatternInstance = await data.dataViews.get(currentIndexPattern === null || currentIndexPattern === void 0 ? void 0 : currentIndexPattern.id);
      closeFieldEditor.current = await dataViewFieldEditor.openEditor({
        ctx: {
          dataView: indexPatternInstance
        },
        fieldName,
        onSave: () => {
          if (indexPatternInstance.isPersisted()) {
            refreshFieldList();
          } else {
            indexPatternService.replaceDataViewId(indexPatternInstance);
          }
        }
      });
    }
  } : undefined, [canEditDataView, currentIndexPattern === null || currentIndexPattern === void 0 ? void 0 : currentIndexPattern.id, data.dataViews, dataViewFieldEditor, indexPatternService, refreshFieldList]);
  const addField = (0, _react.useMemo)(() => canEditDataView && editField ? () => editField(undefined, 'add') : undefined, [editField, canEditDataView]);
  const createNewDataView = (0, _react.useCallback)(() => {
    closeDataViewEditor.current = dataViewEditor.openEditor({
      onSave: async dataView => {
        if (dataView.id) {
          if (isOnTextBasedMode) {
            dispatch((0, _state_management.switchAndCleanDatasource)({
              newDatasourceId: 'formBased',
              visualizationId: visualization === null || visualization === void 0 ? void 0 : visualization.activeId,
              currentIndexPatternId: dataView === null || dataView === void 0 ? void 0 : dataView.id
            }));
          }
          dispatchChangeIndexPattern(dataView);
          setCurrentIndexPattern(dataView);
        }
      },
      allowAdHocDataView: true
    });
  }, [dataViewEditor, dispatch, dispatchChangeIndexPattern, isOnTextBasedMode, visualization === null || visualization === void 0 ? void 0 : visualization.activeId]);
  const onCreateDefaultAdHocDataView = (0, _react.useCallback)(async dataViewSpec => {
    var _dataView$fields$getB;
    const dataView = await dataViewsService.create(dataViewSpec);
    if (((_dataView$fields$getB = dataView.fields.getByName('@timestamp')) === null || _dataView$fields$getB === void 0 ? void 0 : _dataView$fields$getB.type) === 'date') {
      dataView.timeFieldName = '@timestamp';
    }
    if (isOnTextBasedMode) {
      dispatch((0, _state_management.switchAndCleanDatasource)({
        newDatasourceId: 'formBased',
        visualizationId: visualization === null || visualization === void 0 ? void 0 : visualization.activeId,
        currentIndexPatternId: dataView === null || dataView === void 0 ? void 0 : dataView.id
      }));
    }
    dispatchChangeIndexPattern(dataView);
    setCurrentIndexPattern(dataView);
  }, [dataViewsService, dispatch, dispatchChangeIndexPattern, isOnTextBasedMode, visualization === null || visualization === void 0 ? void 0 : visualization.activeId]);
  const dataViewPickerProps = {
    trigger: {
      label: (currentIndexPattern === null || currentIndexPattern === void 0 ? void 0 : (_currentIndexPattern$ = currentIndexPattern.getName) === null || _currentIndexPattern$ === void 0 ? void 0 : _currentIndexPattern$.call(currentIndexPattern)) || '',
      'data-test-subj': 'lns-dataView-switch-link',
      title: (currentIndexPattern === null || currentIndexPattern === void 0 ? void 0 : currentIndexPattern.title) || ''
    },
    currentDataViewId: currentIndexPattern === null || currentIndexPattern === void 0 ? void 0 : currentIndexPattern.id,
    onAddField: addField,
    onDataViewCreated: createNewDataView,
    onCreateDefaultAdHocDataView,
    adHocDataViews,
    onChangeDataView: async newIndexPatternId => {
      const currentDataView = await data.dataViews.get(newIndexPatternId);
      setCurrentIndexPattern(currentDataView);
      dispatchChangeIndexPattern(newIndexPatternId);
      if (isOnTextBasedMode) {
        dispatch((0, _state_management.switchAndCleanDatasource)({
          newDatasourceId: 'formBased',
          visualizationId: visualization === null || visualization === void 0 ? void 0 : visualization.activeId,
          currentIndexPatternId: newIndexPatternId
        }));
      }
    },
    onEditDataView: async updatedDataViewStub => {
      if (!currentIndexPattern) return;
      if (currentIndexPattern.isPersisted()) {
        // clear instance cache and fetch again to make sure fields are up to date (in case pattern changed)
        dataViewsService.clearInstanceCache(currentIndexPattern.id);
        const updatedCurrentIndexPattern = await dataViewsService.get(currentIndexPattern.id);
        // if the data view was persisted, reload it from cache
        const updatedCache = {
          ...dataViews.indexPatterns
        };
        delete updatedCache[currentIndexPattern.id];
        const newIndexPatterns = await indexPatternService.ensureIndexPattern({
          id: updatedCurrentIndexPattern.id,
          cache: updatedCache
        });
        dispatch((0, _lens_slice.changeIndexPattern)({
          dataViews: {
            indexPatterns: newIndexPatterns
          },
          indexPatternId: updatedCurrentIndexPattern.id
        }));
        // Renew session id to make sure the request is done again
        dispatchSetState({
          searchSessionId: data.search.session.start(),
          resolvedDateRange: (0, _utils.getResolvedDateRange)(data.query.timefilter.timefilter)
        });
        // update list of index patterns to pick up mutations in the changed data view
        setCurrentIndexPattern(updatedCurrentIndexPattern);
      } else {
        // if it was an ad-hoc data view, we need to switch to a new data view anyway
        indexPatternService.replaceDataViewId(updatedDataViewStub);
      }
    }
  };
  const textBasedLanguageModeErrors = getUserMessages('textBasedLanguagesQueryInput', {
    severity: 'error'
  }).map(({
    shortMessage
  }) => new Error(shortMessage));
  const managed = (0, _state_management.useLensSelector)(_state_management.selectIsManaged);
  return /*#__PURE__*/_react.default.createElement(AggregateQueryTopNavMenu, {
    setMenuMountPoint: setHeaderActionMenu,
    popoverBreakpoints: ['xs', 's', 'm'],
    config: topNavConfig,
    allowSavingQueries: true,
    badges: managed ? [(0, _managedContentBadge.getManagedContentBadge)(_i18n.i18n.translate('xpack.lens.managedBadgeTooltip', {
      defaultMessage: 'This visualization is managed by Elastic. Changes made here must be saved in a new visualization.'
    }))] : undefined,
    savedQuery: savedQuery,
    onQuerySubmit: onQuerySubmitWrapped,
    onSaved: onSavedWrapped,
    onSavedQueryUpdated: onSavedQueryUpdatedWrapped,
    onClearSavedQuery: onClearSavedQueryWrapped,
    indexPatterns: indexPatterns,
    query: query,
    dateRangeFrom: from,
    dateRangeTo: to,
    indicateNoData: indicateNoData,
    showSearchBar: true,
    dataViewPickerComponentProps: dataViewPickerProps,
    showDatePicker: indexPatterns.some(ip => ip.isTimeBased()) ||
    // always show the timepicker for text based languages
    isOnTextBasedMode || Boolean(allLoaded && activeDatasourceId && datasourceMap[activeDatasourceId].isTimeBased(datasourceStates[activeDatasourceId].state, dataViews.indexPatterns)),
    textBasedLanguageModeErrors: textBasedLanguageModeErrors,
    showFilterBar: true,
    "data-test-subj": "lnsApp_topNav",
    screenTitle: 'lens',
    appName: _constants.LENS_APP_NAME,
    displayStyle: "detached",
    className: "hide-for-sharing"
  });
};
exports.LensTopNavMenu = LensTopNavMenu;