"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopCategoriesSection = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _loading_overlay_wrapper = require("../../../../../components/loading_overlay_wrapper");
var _top_categories_table = require("./top_categories_table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TopCategoriesSection = ({
  isLoadingTopCategories = false,
  jobId,
  logViewReference,
  timeRange,
  topCategories,
  sortOptions,
  changeSortOptions
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_loading_overlay_wrapper.LoadingOverlayWrapper, {
    isLoading: isLoadingTopCategories,
    loadingChildren: /*#__PURE__*/_react.default.createElement(LoadingOverlayContent, null)
  }, /*#__PURE__*/_react.default.createElement(_top_categories_table.TopCategoriesTable, {
    categorizationJobId: jobId,
    logViewReference: logViewReference,
    timeRange: timeRange,
    topCategories: topCategories,
    sortOptions: sortOptions,
    changeSortOptions: changeSortOptions
  })));
};
exports.TopCategoriesSection = TopCategoriesSection;
const loadingAriaLabel = _i18n.i18n.translate('xpack.infra.logs.logEntryCategories.topCategoriesSectionLoadingAriaLabel', {
  defaultMessage: 'Loading message categories'
});
const LoadingOverlayContent = () => /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
  size: "xl",
  "aria-label": loadingAriaLabel
});