"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInfraMLCapabilitiesContext = exports.useInfraMLCapabilities = exports.InfraMLCapabilitiesProvider = void 0;
var _constate = _interopRequireDefault(require("constate"));
var _react = require("react");
var _Either = require("fp-ts/Either");
var _pipeable = require("fp-ts/pipeable");
var _function = require("fp-ts/function");
var _ioTsUtils = require("@kbn/io-ts-utils");
var _use_tracked_promise = require("../../hooks/use_tracked_promise");
var _ml_api_types = require("./api/ml_api_types");
var _use_kibana = require("../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useInfraMLCapabilities = () => {
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const [mlCapabilities, setMlCapabilities] = (0, _react.useState)(initialMlCapabilities);
  const [fetchMlCapabilitiesRequest, fetchMlCapabilities] = (0, _use_tracked_promise.useTrackedPromise)({
    cancelPreviousOn: 'resolution',
    createPromise: async () => {
      const rawResponse = await services.http.fetch('/internal/ml/ml_capabilities', {
        version: '1'
      });
      return (0, _pipeable.pipe)(_ml_api_types.getMlCapabilitiesResponsePayloadRT.decode(rawResponse), (0, _Either.fold)((0, _ioTsUtils.throwErrors)(_ioTsUtils.createPlainError), _function.identity));
    },
    onResolve: response => {
      setMlCapabilities(response);
    }
  }, []);
  (0, _react.useEffect)(() => {
    fetchMlCapabilities();
  }, [fetchMlCapabilities]);
  const isLoading = (0, _react.useMemo)(() => fetchMlCapabilitiesRequest.state === 'pending', [fetchMlCapabilitiesRequest.state]);
  const hasInfraMLSetupCapabilities = mlCapabilities.capabilities.canCreateJob;
  const hasInfraMLReadCapabilities = mlCapabilities.capabilities.canGetJobs;
  const hasInfraMLCapabilities = mlCapabilities.isPlatinumOrTrialLicense && mlCapabilities.mlFeatureEnabledInSpace;
  return {
    hasInfraMLCapabilities,
    hasInfraMLReadCapabilities,
    hasInfraMLSetupCapabilities,
    isLoading
  };
};
exports.useInfraMLCapabilities = useInfraMLCapabilities;
const [InfraMLCapabilitiesProvider, useInfraMLCapabilitiesContext] = (0, _constate.default)(useInfraMLCapabilities);
exports.useInfraMLCapabilitiesContext = useInfraMLCapabilitiesContext;
exports.InfraMLCapabilitiesProvider = InfraMLCapabilitiesProvider;
const initialMlCapabilities = {
  capabilities: {
    canGetJobs: false,
    canCreateJob: false,
    canDeleteJob: false,
    canOpenJob: false,
    canCloseJob: false,
    canForecastJob: false,
    canGetDatafeeds: false,
    canStartStopDatafeed: false,
    canUpdateJob: false,
    canUpdateDatafeed: false,
    canPreviewDatafeed: false,
    canGetCalendars: false,
    canCreateCalendar: false,
    canDeleteCalendar: false,
    canGetFilters: false,
    canCreateFilter: false,
    canDeleteFilter: false,
    canFindFileStructure: false,
    canGetDataFrameJobs: false,
    canDeleteDataFrameJob: false,
    canPreviewDataFrameJob: false,
    canCreateDataFrameJob: false,
    canStartStopDataFrameJob: false
  },
  isPlatinumOrTrialLicense: false,
  mlFeatureEnabledInSpace: false,
  upgradeInProgress: false
};