"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlUnavailablePrompt = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MlUnavailablePrompt = () => /*#__PURE__*/_react.default.createElement(EmptyPrompt, {
  title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.logs.analysis.mlUnavailableTitle",
    defaultMessage: "This feature requires Machine Learning"
  })),
  body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.logs.analysis.mlUnavailableBody",
    defaultMessage: "Check the {machineLearningAppLink} for more information.",
    values: {
      machineLearningAppLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "infraMlUnavailablePromptMachineLearningAppLink",
        href: "ml",
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.logs.analysisPage.unavailable.mlAppLink",
        defaultMessage: "Machine Learning app"
      }))
    }
  })),
  actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraMlUnavailablePromptOpenMachineLearningButton",
    target: "_blank",
    href: "ml",
    color: "primary",
    fill: true
  }, _i18n.i18n.translate('xpack.infra.logs.analysis.mlAppButton', {
    defaultMessage: 'Open Machine Learning'
  }))
});
exports.MlUnavailablePrompt = MlUnavailablePrompt;
const EmptyPrompt = (0, _styled.default)(_eui.EuiEmptyPrompt)`
  align-self: center;
`;