"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricRowWithCount = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _kuery_bar = require("../../../../pages/metrics/metrics_explorer/components/kuery_bar");
var _metrics = require("../../../../../common/alerting/metrics");
var _metric_row_controls = require("./metric_row_controls");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetricRowWithCount = ({
  name,
  agg,
  filter,
  onDelete,
  disableDelete,
  onChange,
  aggregationTypes
}) => {
  const aggOptions = (0, _react.useMemo)(() => Object.values(aggregationTypes).filter(aggType => aggType.value !== _metrics.Aggregators.CUSTOM).map(aggType => ({
    text: aggType.text,
    value: aggType.value
  })), [aggregationTypes]);
  const handleDelete = (0, _react.useCallback)(() => {
    onDelete(name);
  }, [name, onDelete]);
  const handleAggChange = (0, _react.useCallback)(el => {
    onChange({
      name,
      filter,
      aggType: el.target.value
    });
  }, [name, filter, onChange]);
  const handleFilterChange = (0, _react.useCallback)(filterString => {
    onChange({
      name,
      filter: filterString,
      aggType: agg
    });
  }, [name, agg, onChange]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      maxWidth: 145
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.customEquationEditor.aggregationLabel', {
      defaultMessage: 'Aggregation {name}',
      values: {
        name
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "infraMetricRowWithCountSelect",
    compressed: true,
    options: aggOptions,
    value: agg,
    onChange: handleAggChange
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.customEquationEditor.filterLabel', {
      defaultMessage: 'KQL Filter {name}',
      values: {
        name
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_kuery_bar.MetricsExplorerKueryBar, {
    placeholder: ' ',
    compressed: true,
    onChange: handleFilterChange,
    onSubmit: handleFilterChange,
    value: filter
  }))), /*#__PURE__*/_react.default.createElement(_metric_row_controls.MetricRowControls, {
    onDelete: handleDelete,
    disableDelete: disableDelete
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }));
};
exports.MetricRowWithCount = MetricRowWithCount;