"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatHttpError = formatHttpError;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function formatHttpError(error) {
  var _error$body, _error$body2, _error$body3;
  if (!error.response) {
    return _i18n.i18n.translate('xpack.graph.fatalError.unavailableServerErrorMessage', {
      defaultMessage: 'An HTTP request has failed to connect. ' + 'Please check if the Kibana server is running and that your browser has a working connection, ' + 'or contact your system administrator.'
    });
  }
  return _i18n.i18n.translate('xpack.graph.fatalError.errorStatusMessage', {
    defaultMessage: 'Error {errStatus} {errStatusText}: {errMessage}',
    values: {
      errStatus: (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.status,
      errStatusText: (_error$body2 = error.body) === null || _error$body2 === void 0 ? void 0 : _error$body2.statusText,
      errMessage: (_error$body3 = error.body) === null || _error$body3 === void 0 ? void 0 : _error$body3.message
    }
  });
}