"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.disableBrowserInputWhenBothEnabled = void 0;
var _epm = require("../../../common/constants/epm");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const disableBrowserInputWhenBothEnabled = doc => {
  var _doc$attributes$packa;
  const pkg = (_doc$attributes$packa = doc.attributes.package) === null || _doc$attributes$packa === void 0 ? void 0 : _doc$attributes$packa.name;
  if (pkg !== _epm.FLEET_SYNTHETICS_PACKAGE) return {
    document: doc
  };
  const enabledInputs = doc.attributes.inputs.filter(i => i.enabled);
  if (enabledInputs.length === 1) return {
    document: doc
  };
  for (const input of doc.attributes.inputs) {
    if (input.type === 'synthetics/browser') input.enabled = false;
  }
  return {
    document: {
      ...doc,
      attributes: {
        ...doc.attributes,
        bump_agent_policy_revision: true
      }
    }
  };
};
exports.disableBrowserInputWhenBothEnabled = disableBrowserInputWhenBothEnabled;