"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstalledIntegrationsSearchBar = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _use_url_filters = require("../hooks/use_url_filters");
var _installed_integration_action_menu = require("./installed_integration_action_menu");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SEARCH_DEBOUNCE_MS = 250;
const InstalledIntegrationsSearchBar = ({
  filters,
  countPerStatus,
  customIntegrationsCount,
  selectedItems
}) => {
  const addUrlFilter = (0, _use_url_filters.useAddUrlFilters)();
  const theme = (0, _eui.useEuiTheme)();
  const [searchTerms, setSearchTerms] = (0, _react.useState)(filters.q);
  (0, _useDebounce.default)(() => {
    addUrlFilter({
      q: searchTerms
    });
  }, SEARCH_DEBOUNCE_MS, [searchTerms]);
  const statuses = (0, _react.useMemo)(() => [{
    iconType: 'warning',
    iconColor: theme.euiTheme.colors.textWarning,
    status: 'upgrade_available',
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epmInstalledIntegrations.upgradeAvailableFilterLabel",
      defaultMessage: "Upgrade"
    })
  }, {
    iconType: 'error',
    iconColor: theme.euiTheme.colors.textDanger,
    status: 'upgrade_failed',
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epmInstalledIntegrations.upgradeFailerFilterLabel",
      defaultMessage: "Upgrade failed"
    })
  }, {
    iconType: 'error',
    iconColor: theme.euiTheme.colors.textDanger,
    status: 'install_failed',
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epmInstalledIntegrations.installFailerFilterLabel",
      defaultMessage: "Install failed"
    })
  }], [theme]);
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    defaultValue: filters.q,
    onChange: e => setSearchTerms(e.target.value),
    placeholder: _i18n.i18n.translate('xpack.fleet.serachBarPlaceholder', {
      defaultMessage: 'Search'
    }),
    fullWidth: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, statuses.map(item => {
    var _filters$installation, _countPerStatus$item$;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      iconType: item.iconType,
      iconSide: "left",
      css: (0, _react2.css)`
                  .euiIcon {
                    color: ${item.iconColor};
                  }
                `,
      hasActiveFilters: (_filters$installation = filters.installationStatus) === null || _filters$installation === void 0 ? void 0 : _filters$installation.includes(item.status),
      numFilters: (_countPerStatus$item$ = countPerStatus[item.status]) !== null && _countPerStatus$item$ !== void 0 ? _countPerStatus$item$ : 0,
      onClick: () => {
        var _filters$installation2;
        if (!((_filters$installation2 = filters.installationStatus) !== null && _filters$installation2 !== void 0 && _filters$installation2.includes(item.status))) {
          addUrlFilter({
            installationStatus: [item.status]
          });
        } else {
          addUrlFilter({
            installationStatus: []
          });
        }
      }
    }, item.label);
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    hasActiveFilters: filters.customIntegrations,
    numFilters: customIntegrationsCount,
    onClick: () => {
      if (filters.customIntegrations) {
        addUrlFilter({
          customIntegrations: undefined
        });
      } else {
        addUrlFilter({
          customIntegrations: true
        });
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epmInstalledIntegrations.customFilterLabel",
    defaultMessage: "Custom"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_installed_integration_action_menu.InstalledIntegrationsActionMenu, {
    selectedItems: selectedItems
  }))));
};
exports.InstalledIntegrationsSearchBar = InstalledIntegrationsSearchBar;