"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGettingStartedStep = getGettingStartedStep;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _multi_row_input = require("../../../sections/settings/components/multi_row_input");
var _hooks = require("../../../hooks");
var _components = require("../components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getGettingStartedStep(props) {
  return {
    title: _i18n.i18n.translate('xpack.fleet.fleetServerFlyout.getStartedTitle', {
      defaultMessage: 'Get started with Fleet Server'
    }),
    status: props.status === 'success' ? 'complete' : 'current',
    children: /*#__PURE__*/_react.default.createElement(GettingStartedStepContent, props)
  };
}
const GettingStartedStepContent = ({
  fleetServerHosts,
  fleetServerHost: selectedFleetServerHost,
  setFleetServerHost,
  status,
  error,
  inputs,
  submit,
  onClose
}) => {
  const {
    getHref
  } = (0, _hooks.useLink)();
  const authz = (0, _hooks.useAuthz)();
  const canWritePolicies = authz.fleet.allAgentPolicies && authz.integrations.writeIntegrationPolicies;
  const isDisabled = fleetServerHosts.length === 0 && !canWritePolicies;
  if (status === 'success') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "success",
      iconType: "check",
      title: _i18n.i18n.translate('xpack.fleet.fleetServerFlyout.generateFleetServerPolicySuccessTitle', {
        defaultMessage: 'Fleet Server policy created.'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.fleetServerFlyout.generateFleetServerPolicySuccessInstructions",
      defaultMessage: "Fleet server policy and service token have been generated. Host configured at {hostUrl}. You can edit your Fleet Server hosts in {fleetSettingsLink}.",
      values: {
        hostUrl: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, selectedFleetServerHost === null || selectedFleetServerHost === void 0 ? void 0 : selectedFleetServerHost.host_urls[0]),
        fleetSettingsLink:
        /*#__PURE__*/
        // eslint-disable-next-line @elastic/eui/href-or-on-click
        _react.default.createElement(_eui.EuiLink, {
          href: getHref('settings'),
          onClick: onClose
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.fleetServerSetup.fleetSettingsLink",
          defaultMessage: "Fleet Settings"
        }))
      }
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.fleetServerSetup.getStartedInstructions",
    defaultMessage: "First, set the public IP or host name and port that agents will use to reach Fleet Server. It uses port {port} by default {toolTip}. We'll then generate a policy for you automatically.",
    values: {
      port: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "8220"),
      toolTip: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        iconProps: {
          className: 'eui-alignTop'
        },
        content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.fleetServerSetup.getStartedInstructionsPortTooltips",
          defaultMessage: "This can only be set during Fleet Server installation."
        }),
        position: "right"
      })
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), selectedFleetServerHost ? /*#__PURE__*/_react.default.createElement(_components.FleetServerHostSelect, {
    setFleetServerHost: setFleetServerHost,
    selectedFleetServerHost: selectedFleetServerHost,
    fleetServerHosts: fleetServerHosts
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    onSubmit: submit
  }, !selectedFleetServerHost ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.fleetServerSetup.nameInputLabel",
      defaultMessage: "Name"
    })
  }, inputs.nameInput.formRowProps), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
    "data-test-subj": "fleetServerSetup.nameInput",
    fullWidth: true,
    placeholder: _i18n.i18n.translate('xpack.fleet.fleetServerSetup.nameInputPlaceholder', {
      defaultMessage: 'Specify name'
    })
  }, inputs.nameInput.props, {
    disabled: isDisabled
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.fleetServerSetup.hostUrlLabel",
      defaultMessage: "URL"
    })
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_multi_row_input.MultiRowInput, (0, _extends2.default)({
    "data-test-subj": "fleetServerSetup.multiRowInput"
  }, inputs.hostUrlsInput.props, {
    disabled: isDisabled,
    placeholder: _i18n.i18n.translate('xpack.fleet.fleetServerSetup.fleetServerHostsInputPlaceholder', {
      defaultMessage: 'Specify host URL'
    }),
    isUrl: true
  })), status === 'error' && /*#__PURE__*/_react.default.createElement(_eui.EuiFormErrorText, null, error))), fleetServerHosts.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true
  }, inputs.isDefaultInput.formRowProps), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, (0, _extends2.default)({
    "data-test-subj": "fleetServerHostsFlyout.isDefaultSwitch"
  }, inputs.isDefaultInput.props, {
    disabled: false,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.fleetServerHostsFlyout.defaultOutputSwitchLabel",
      defaultMessage: "Make this Fleet server the default one."
    })
  }))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isLoading: status === 'loading',
    onClick: submit,
    "data-test-subj": "generateFleetServerPolicyButton",
    disabled: isDisabled
  }, fleetServerHosts.length > 0 ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.fleetServerFlyout.continueFleetServerPolicyButton",
    defaultMessage: "Continue"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.fleetServerFlyout.generateFleetServerPolicyButton",
    defaultMessage: "Generate Fleet Server policy"
  }))));
};