"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.pageSize = exports.page = exports.fileNameWithExt = exports.fileName = exports.fileMeta = exports.fileAlt = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const fileName = exports.fileName = _configSchema.schema.string({
  minLength: 1,
  maxLength: 256
});
const fileNameWithExt = exports.fileNameWithExt = _configSchema.schema.string({
  minLength: 1,
  maxLength: 256
});
const fileAlt = exports.fileAlt = _configSchema.schema.maybe(_configSchema.schema.string({
  minLength: 1,
  maxLength: 256
}));
const page = exports.page = _configSchema.schema.number({
  min: 1,
  defaultValue: 1
});
const pageSize = exports.pageSize = _configSchema.schema.number({
  min: 1,
  defaultValue: 100
});
const fileMeta = exports.fileMeta = _configSchema.schema.maybe(_configSchema.schema.object({}, {
  unknowns: 'allow'
}));