"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNSUPPORTED_COMMANDS_BEFORE_QSTR = exports.UNSUPPORTED_COMMANDS_BEFORE_MATCH = exports.TICKS_REGEX = exports.SINGLE_TICK_REGEX = exports.SINGLE_BACKTICK = exports.METADATA_FIELDS = exports.FULL_TEXT_SEARCH_FUNCTIONS = exports.ESQL_VARIABLES_PREFIX = exports.EDITOR_MARKER = exports.DOUBLE_TICKS_REGEX = exports.DOUBLE_BACKTICK = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const EDITOR_MARKER = exports.EDITOR_MARKER = 'marker_esql_editor';
const TICKS_REGEX = exports.TICKS_REGEX = /^`{1}|`{1}$/g;
const DOUBLE_TICKS_REGEX = exports.DOUBLE_TICKS_REGEX = /``/g;
const SINGLE_TICK_REGEX = exports.SINGLE_TICK_REGEX = /`/g;
const DOUBLE_BACKTICK = exports.DOUBLE_BACKTICK = '``';
const SINGLE_BACKTICK = exports.SINGLE_BACKTICK = '`';
const ESQL_VARIABLES_PREFIX = exports.ESQL_VARIABLES_PREFIX = '?';
const METADATA_FIELDS = exports.METADATA_FIELDS = ['_version', '_id', '_index', '_source', '_ignored', '_index_mode', '_score'];
const FULL_TEXT_SEARCH_FUNCTIONS = exports.FULL_TEXT_SEARCH_FUNCTIONS = ['match', 'match_operator', 'qstr', 'kql'];
const UNSUPPORTED_COMMANDS_BEFORE_QSTR = exports.UNSUPPORTED_COMMANDS_BEFORE_QSTR = new Set(['show', 'row', 'dissect', 'enrich', 'eval', 'grok', 'keep', 'mv_expand', 'rename', 'stats', 'limit']);
const UNSUPPORTED_COMMANDS_BEFORE_MATCH = exports.UNSUPPORTED_COMMANDS_BEFORE_MATCH = new Set(['limit']);