"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.suggest = suggest;
var _helpers = require("../../../shared/helpers");
var _complete_items = require("../../complete_items");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function suggest({
  innerText,
  getColumnsByType
}) {
  if (/MV_EXPAND\s+\S+\s+$/i.test(innerText)) {
    return [_complete_items.pipeCompleteItem];
  }
  const columnSuggestions = await getColumnsByType('any', undefined, {
    advanceCursor: true,
    openSuggestions: true
  });
  const fragment = (0, _helpers.findFinalWord)(innerText);
  columnSuggestions.forEach(suggestion => {
    suggestion.rangeToReplace = {
      start: innerText.length - fragment.length + 1,
      end: innerText.length
    };
  });
  return columnSuggestions;
}