"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MODEL_TITLES_BY_TYPE = exports.ELSER_MODEL_PLACEHOLDER = exports.ELSER_LINUX_OPTIMIZED_MODEL_PLACEHOLDER = exports.E5_MODEL_PLACEHOLDER = exports.E5_LINUX_OPTIMIZED_MODEL_PLACEHOLDER = exports.BASE_MODEL = void 0;
var _i18n = require("@kbn/i18n");
var _mlTrainedModelsUtils = require("@kbn/ml-trained-models-utils");
var _ml = require("../../../common/types/ml");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MODEL_TITLES_BY_TYPE = exports.MODEL_TITLES_BY_TYPE = {
  fill_mask: _i18n.i18n.translate('xpack.enterpriseSearch.content.ml_inference.fill_mask', {
    defaultMessage: 'Fill Mask'
  }),
  lang_ident: _i18n.i18n.translate('xpack.enterpriseSearch.content.ml_inference.lang_ident', {
    defaultMessage: 'Language Identification'
  }),
  ner: _i18n.i18n.translate('xpack.enterpriseSearch.content.ml_inference.ner', {
    defaultMessage: 'Named Entity Recognition'
  }),
  question_answering: _i18n.i18n.translate('xpack.enterpriseSearch.content.ml_inference.question_answering', {
    defaultMessage: 'Question Answering'
  }),
  text_classification: _i18n.i18n.translate('xpack.enterpriseSearch.content.ml_inference.text_classification', {
    defaultMessage: 'Text Classification'
  }),
  text_embedding: _i18n.i18n.translate('xpack.enterpriseSearch.content.ml_inference.text_embedding', {
    defaultMessage: 'Dense Vector Text Embedding'
  }),
  text_expansion: _i18n.i18n.translate('xpack.enterpriseSearch.content.ml_inference.text_expansion', {
    defaultMessage: 'Elastic Learned Sparse EncodeR (ELSER)'
  }),
  zero_shot_classification: _i18n.i18n.translate('xpack.enterpriseSearch.content.ml_inference.zero_shot_classification', {
    defaultMessage: 'Zero-Shot Text Classification'
  })
};
const BASE_MODEL = exports.BASE_MODEL = {
  deploymentState: _ml.MlModelDeploymentState.NotDeployed,
  nodeAllocationCount: 0,
  startTime: 0,
  targetAllocationCount: 0,
  threadsPerAllocation: 0,
  isPlaceholder: false,
  hasStats: false,
  types: [],
  inputFieldNames: []
};
const ELSER_MODEL_PLACEHOLDER = exports.ELSER_MODEL_PLACEHOLDER = {
  ...BASE_MODEL,
  modelId: _mlTrainedModelsUtils.ELSER_MODEL_ID,
  type: _mlTrainedModelsUtils.SUPPORTED_PYTORCH_TASKS.TEXT_EXPANSION,
  title: 'ELSER (Elastic Learned Sparse EncodeR)',
  description: _i18n.i18n.translate('xpack.enterpriseSearch.modelCard.elserPlaceholder.description', {
    defaultMessage: "ELSER is Elastic's NLP model for English semantic search, utilizing sparse vectors. It prioritizes intent and contextual meaning over literal term matching, optimized specifically for English documents and queries on the Elastic platform."
  }),
  isPlaceholder: true
};
const ELSER_LINUX_OPTIMIZED_MODEL_PLACEHOLDER = exports.ELSER_LINUX_OPTIMIZED_MODEL_PLACEHOLDER = {
  ...ELSER_MODEL_PLACEHOLDER,
  modelId: _mlTrainedModelsUtils.ELSER_LINUX_OPTIMIZED_MODEL_ID,
  title: 'ELSER (Elastic Learned Sparse EncodeR), optimized for linux-x86_64'
};
const E5_MODEL_PLACEHOLDER = exports.E5_MODEL_PLACEHOLDER = {
  ...BASE_MODEL,
  modelId: _mlTrainedModelsUtils.E5_MODEL_ID,
  type: _mlTrainedModelsUtils.SUPPORTED_PYTORCH_TASKS.TEXT_EMBEDDING,
  title: 'E5 (EmbEddings from bidirEctional Encoder rEpresentations)',
  description: _i18n.i18n.translate('xpack.enterpriseSearch.modelCard.e5Placeholder.description', {
    defaultMessage: 'E5 is a third party NLP model that enables you to perform multi-lingual semantic search by using dense vector representations. This model performs best for non-English language documents and queries.'
  }),
  licenseType: 'mit',
  modelDetailsPageUrl: 'https://ela.st/multilingual-e5-small',
  isPlaceholder: true
};
const E5_LINUX_OPTIMIZED_MODEL_PLACEHOLDER = exports.E5_LINUX_OPTIMIZED_MODEL_PLACEHOLDER = {
  ...E5_MODEL_PLACEHOLDER,
  modelId: _mlTrainedModelsUtils.E5_LINUX_OPTIMIZED_MODEL_ID,
  title: 'E5 (EmbEddings from bidirEctional Encoder rEpresentations), optimized for linux-x86_64',
  modelDetailsPageUrl: 'https://ela.st/multilingual-e5-small-linux-x86-64'
};