"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GenericEndpointInlineEditableTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _inline_editable_table = require("../inline_editable_table/inline_editable_table");
var _generic_endpoint_inline_editable_table_logic = require("./generic_endpoint_inline_editable_table_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GenericEndpointInlineEditableTable = ({
  addRoute,
  dataProperty,
  deleteRoute,
  reorderRoute,
  updateRoute,
  onAdd,
  onDelete,
  onReorder,
  onUpdate,
  ...props
}) => {
  const {
    instanceId
  } = props;
  const genericEndpointLogic = (0, _generic_endpoint_inline_editable_table_logic.GenericEndpointInlineEditableTableLogic)({
    dataProperty,
    instanceId,
    addRoute,
    deleteRoute,
    reorderRoute,
    updateRoute,
    onAdd,
    onDelete,
    onReorder,
    onUpdate
  });
  const {
    isLoading
  } = (0, _kea.useValues)(genericEndpointLogic);
  const {
    addItem,
    deleteItem,
    reorderItems,
    updateItem
  } = (0, _kea.useActions)(genericEndpointLogic);
  return /*#__PURE__*/_react.default.createElement(_inline_editable_table.InlineEditableTable, (0, _extends2.default)({}, props, {
    isLoading: isLoading,
    onAdd: addItem,
    onDelete: deleteItem,
    onReorder: reorderItems,
    onUpdate: updateItem
  }));
};
exports.GenericEndpointInlineEditableTable = GenericEndpointInlineEditableTable;