"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SemanticSearchGuide = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _ai_search_docs_section = require("../../../ai_search/components/ai_search_guide/ai_search_docs_section");
var _doc_links = require("../../../shared/doc_links");
var _kibana_chrome = require("../../../shared/kibana_chrome");
var _dev_tools_console_code_block = require("../../../vector_search/components/dev_tools_console_code_block/dev_tools_console_code_block");
require("./semantic_search_guide.scss");
var _page_template = require("../layout/page_template");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SETUP_INFERENCE_ENDPOINT_ELSER = `PUT _inference/sparse_embedding/my-inference-endpoint
{
  "service": "elser",
  "service_settings": {
    "num_allocations": 1,
    "num_threads": 1
  }
}
`;
const SETUP_INFERENCE_ENDPOINT_E5 = `PUT _inference/text_embedding/my-inference-endpoint
{
  "service": "elasticsearch",
  "service_settings": {
    "model_id": ".multilingual-e5-small",
    "num_allocations": 1,
    "num_threads": 1
  }
}
`;
const SETUP_INFERENCE_ENDPOINT_OPENAI = `PUT _inference/text_embedding/my-inference-endpoint
{
  "service": "openai",
  "service_settings": {
    "model_id": "text-embedding-3-small",
    "api_key": "<api_key>",
  }
}
`;
const SETUP_INFERENCE_ENDPOINT_BEDROCK = `PUT _inference/text_embedding/my-inference-endpoint
{
  "service": "amazonbedrock",
  "service_settings": {
    "access_key": "<aws_access_key>",
    "secret_key": "<aws_secret_key>",
    "region": "us-east-1",
    "provider": "amazontitan",
    "model": "amazon.titan-embed-text-v2:0"
  }
}
`;
const CREATE_INDEX_SNIPPET = `PUT /my-index
{
  "mappings": {
    "properties": {
      "text": {
        "type": "semantic_text",
        "inference_id": "my-inference-endpoint"
      }
    }
  }
}`;
const INGEST_SNIPPET = `POST /my-index/_doc
{
  "text": "There are a few foods and food groups that will help to fight inflammation and delayed onset muscle soreness (both things that are inevitable after a long, hard workout) when you incorporate them into your postworkout eats, whether immediately after your run or at a meal later in the day"
}`;
const QUERY_SNIPPET = `POST /my-index/_search
{
  "size" : 3,
  "query" : {
    "semantic": {
      "field": "text",
      "query": "How to avoid muscle soreness while running?"
    }
  }
}`;
const modelSelection = [{
  id: 'elser',
  modelName: 'ELSER',
  code: SETUP_INFERENCE_ENDPOINT_ELSER,
  link: _doc_links.docLinks.elser,
  description: "Elastic's proprietary, best-in-class sparse vector model for semantic search."
}, {
  id: 'e5',
  modelName: 'E5 Multilingual',
  code: SETUP_INFERENCE_ENDPOINT_E5,
  link: _doc_links.docLinks.e5Model,
  description: 'Try an optimized third party multilingual model.'
}, {
  code: SETUP_INFERENCE_ENDPOINT_OPENAI,
  id: 'openai',
  modelName: 'OpenAI',
  link: 'https://platform.openai.com/docs/guides/embeddings',
  description: "Connect with OpenAI's embedding models."
}, {
  id: 'bedrock',
  modelName: 'Amazon Bedrock',
  code: SETUP_INFERENCE_ENDPOINT_BEDROCK,
  link: 'https://docs.aws.amazon.com/bedrock/latest/userguide/titan-embedding-models.html',
  description: "Use Amazon Bedrock's embedding models."
}];
const SelectModelPanel = ({
  model,
  setSelectedModel,
  isSelectedModel
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    title: model.modelName,
    className: isSelectedModel ? 'chooseEmbeddingModelSelectedBorder' : 'chooseEmbeddingModelBorder',
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, model.description)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "enterpriseSearchSelectModelPanelReadMoreLink",
      href: model.link,
      target: "_blank",
      "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.semanticSearch.modelAriaLabel', {
        defaultMessage: 'Read more about {modelName}',
        values: {
          modelName: model.modelName
        }
      })
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.semanticSearch.guide.model.link",
      defaultMessage: "Read more"
    }))),
    display: isSelectedModel ? 'primary' : 'plain',
    onClick: () => setSelectedModel(model),
    titleSize: "xs",
    hasBorder: true,
    textAlign: "left"
  }));
};
const SemanticSearchGuide = () => {
  const [searchParams] = (0, _reactRouterDomV5Compat.useSearchParams)();
  const chosenUrlModel = modelSelection.find(model => model.id === searchParams.get('model_example')) || modelSelection[0];
  const [selectedModel, setSelectedModel] = _react.default.useState(chosenUrlModel);
  return /*#__PURE__*/_react.default.createElement(_page_template.EnterpriseSearchSemanticSearchPageTemplate, {
    "data-test-subj": "semanticSearchGuidePage",
    restrictWidth: true,
    pageHeader: {
      description: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.semanticSearch.guide.description",
        defaultMessage: "Semantic search in Elasticsearch is now simpler and more intuitive when you use inference endpoints and the `semantic_text` field type."
      }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: _doc_links.docLinks.semanticTextField,
        target: "_blank",
        "data-test-subj": "vector-search-documentation-link"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.semanticSearch.guide.descriptionLink",
        defaultMessage: "Learn more about semantic_text."
      }))),
      pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.semanticSearch.guide.pageTitle",
        defaultMessage: "Get started with semantic search"
      })
    }
  }, /*#__PURE__*/_react.default.createElement(_kibana_chrome.SetSemanticSearchChrome, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 4
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.semanticSearch.guide.setupInferenceEndpoint.title",
    defaultMessage: "Set up an embedding model"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.semanticSearch.guide.setupInferenceEndpoint.description",
    defaultMessage: "To transform your text into embeddings within Elasticsearch, use an inference endpoint to access popular embedding models from Elastic, Amazon, OpenAI, and more. Start by setting up the inference endpoint to manage the model for your task. This may take a while to complete depending on the model you choose and your ML node configuration."
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: _doc_links.docLinks.inferenceApiCreate,
    target: "_blank",
    "data-test-subj": "inference-create-documentation-link"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.semanticSearch.guide.inferenceCreateDocumentationLink",
    defaultMessage: "Learn more about Inference Endpoints."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    direction: "column"
  }, modelSelection.map(model => /*#__PURE__*/_react.default.createElement(SelectModelPanel, {
    key: model.id,
    model: model,
    setSelectedModel: setSelectedModel,
    isSelectedModel: selectedModel === model
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 6
  }, /*#__PURE__*/_react.default.createElement(_dev_tools_console_code_block.DevToolsConsoleCodeBlock, null, selectedModel.code))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 4
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.semanticSearch.guide.createIndex.title",
    defaultMessage: "Create an index"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.semanticSearch.guide.createIndex.description",
    defaultMessage: "Now you need to create an index with one or more {semanticText} fields.",
    values: {
      semanticText: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "semantic_text")
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 6
  }, /*#__PURE__*/_react.default.createElement(_dev_tools_console_code_block.DevToolsConsoleCodeBlock, null, CREATE_INDEX_SNIPPET))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 4
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.semanticSearch.guide.ingest.title",
    defaultMessage: "Ingest your data"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.semanticSearch.guide.ingest.description",
    defaultMessage: "Add data to Elasticsearch using the field name you assigned the semantic_text type to."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 6
  }, /*#__PURE__*/_react.default.createElement(_dev_tools_console_code_block.DevToolsConsoleCodeBlock, null, INGEST_SNIPPET))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 4
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.semanticSearch.guide.query.title",
    defaultMessage: "Perform semantic search"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.semanticSearch.guide.query.description",
    defaultMessage: "Search your data by targeting the semantic_text field with a semantic query."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 6
  }, /*#__PURE__*/_react.default.createElement(_dev_tools_console_code_block.DevToolsConsoleCodeBlock, null, QUERY_SNIPPET))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_ai_search_docs_section.SetAISearchChromeSearchDocsSection, null));
};
exports.SemanticSearchGuide = SemanticSearchGuide;