"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIndexTemplateAndPattern = void 0;
var _coreSavedObjectsUtilsServer = require("@kbn/core-saved-objects-utils-server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getIndexTemplateAndPattern = (context, namespace) => {
  const concreteNamespace = namespace ? namespace : _coreSavedObjectsUtilsServer.DEFAULT_NAMESPACE_STRING;
  const pattern = `${context}`;
  const patternWithNamespace = `${pattern}-${concreteNamespace}`;
  return {
    pattern: `${patternWithNamespace}*`,
    basePattern: `${pattern}-*`,
    name: `${patternWithNamespace}-000001`,
    alias: `${patternWithNamespace}`
  };
};
exports.getIndexTemplateAndPattern = getIndexTemplateAndPattern;