"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExampleAttackDiscoveriesWithReplacements = void 0;
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _get_discoveries_with_original_values = require("../../get_discoveries_with_original_values");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getExampleAttackDiscoveriesWithReplacements = example => {
  var _example$outputs$insi, _example$outputs, _example$outputs2, _example$outputs$repl, _example$outputs3;
  // fallback to the legacy `attackDiscoveries` property for backwards compatibility
  const exampleAttackDiscoveries = (_example$outputs$insi = example === null || example === void 0 ? void 0 : (_example$outputs = example.outputs) === null || _example$outputs === void 0 ? void 0 : _example$outputs.insights) !== null && _example$outputs$insi !== void 0 ? _example$outputs$insi : example === null || example === void 0 ? void 0 : (_example$outputs2 = example.outputs) === null || _example$outputs2 === void 0 ? void 0 : _example$outputs2.attackDiscoveries;
  const exampleReplacements = (_example$outputs$repl = example === null || example === void 0 ? void 0 : (_example$outputs3 = example.outputs) === null || _example$outputs3 === void 0 ? void 0 : _example$outputs3.replacements) !== null && _example$outputs$repl !== void 0 ? _example$outputs$repl : {};

  // NOTE: calls to `parse` throw an error if the Example input is invalid
  const validatedAttackDiscoveries = _elasticAssistantCommon.AttackDiscoveries.parse(exampleAttackDiscoveries);
  const validatedReplacements = _elasticAssistantCommon.Replacements.parse(exampleReplacements);
  const withReplacements = (0, _get_discoveries_with_original_values.getDiscoveriesWithOriginalValues)({
    attackDiscoveries: validatedAttackDiscoveries,
    replacements: validatedReplacements
  });
  return withReplacements;
};
exports.getExampleAttackDiscoveriesWithReplacements = getExampleAttackDiscoveriesWithReplacements;