"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.compatibilityCheck = void 0;
var _discoverUtils = require("@kbn/discover-utils");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const compatibilityCheck = api => {
  return (0, _presentationPublishing.apiCanAccessViewMode)(api) && (0, _presentationPublishing.getInheritedViewMode)(api) === 'view' && (0, _presentationPublishing.apiHasType)(api) && (0, _presentationPublishing.apiIsOfType)(api, _discoverUtils.SEARCH_EMBEDDABLE_TYPE) && (0, _types.apiPublishesSavedSearch)(api);
};
exports.compatibilityCheck = compatibilityCheck;