"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertAppMenuItemToTopNavItem = convertAppMenuItemToTopNavItem;
var _discoverUtils = require("@kbn/discover-utils");
var _run_app_menu_action = require("./run_app_menu_action");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function convertAppMenuItemToTopNavItem({
  appMenuItem,
  services
}) {
  var _appMenuItem$controlP;
  if ('actions' in appMenuItem) {
    var _appMenuItem$descript;
    return {
      id: appMenuItem.id,
      label: appMenuItem.label,
      description: (_appMenuItem$descript = appMenuItem.description) !== null && _appMenuItem$descript !== void 0 ? _appMenuItem$descript : appMenuItem.label,
      testId: appMenuItem.testId,
      run: anchorElement => {
        (0, _run_app_menu_action.runAppMenuPopoverAction)({
          appMenuItem,
          anchorElement,
          services
        });
      }
    };
  }
  return {
    id: appMenuItem.id,
    label: appMenuItem.controlProps.label,
    description: (_appMenuItem$controlP = appMenuItem.controlProps.description) !== null && _appMenuItem$controlP !== void 0 ? _appMenuItem$controlP : appMenuItem.controlProps.label,
    testId: appMenuItem.controlProps.testId,
    run: async anchorElement => {
      await (0, _run_app_menu_action.runAppMenuAction)({
        appMenuItem,
        anchorElement,
        services
      });
    },
    ...(appMenuItem.type === _discoverUtils.AppMenuActionType.primary ? {
      iconType: appMenuItem.controlProps.iconType,
      iconOnly: true
    } : {}),
    ...(appMenuItem.controlProps.href ? {
      href: appMenuItem.controlProps.href
    } : {})
  };
}