"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppNotFound = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const AppNotFound = () => /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate, {
  "data-test-subj": "appNotFoundPageContent"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
  iconType: "warning",
  iconColor: "danger",
  title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "core.application.appNotFound.title",
    defaultMessage: "Application Not Found"
  })),
  body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "core.application.appNotFound.pageDescription",
    defaultMessage: "No application was found at this URL. Try going back or choosing an app from the menu."
  }))
}));
exports.AppNotFound = AppNotFound;