"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StringType = void 0;
var _typeDetect = _interopRequireDefault(require("type-detect"));
var _internals = require("../internals");
var _type = require("./type");
var _oas_meta_fields = require("../oas_meta_fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class StringType extends _type.Type {
  constructor(options = {}) {
    // We want to allow empty strings, however calling `allow('')` causes
    // Joi to allow the value and skip any additional validation.
    // Instead, we reimplement the string validator manually except in the
    // hostname case where empty strings aren't allowed anyways.
    let schema = options.hostname === true ? _internals.internals.string().hostname() : _internals.internals.any().custom((value, {
      error
    }) => {
      if (typeof value !== 'string') {
        if (options.coerceFromNumber && typeof value === 'number') {
          return value.toString(10);
        }
        return error('any.custom', {
          message: `expected value of type [string] but got [${(0, _typeDetect.default)(value)}]`
        });
      }
      return value;
    });
    if (options.minLength !== undefined) {
      schema = schema.custom((0, _type.convertValidationFunction)(value => {
        if (value.length < options.minLength) {
          return `value has length [${value.length}] but it must have a minimum length of [${options.minLength}].`;
        }
      })).meta({
        [_oas_meta_fields.META_FIELD_X_OAS_MIN_LENGTH]: options.minLength
      });
    }
    if (options.maxLength !== undefined) {
      schema = schema.custom((0, _type.convertValidationFunction)(value => {
        if (value.length > options.maxLength) {
          return `value has length [${value.length}] but it must have a maximum length of [${options.maxLength}].`;
        }
      })).meta({
        [_oas_meta_fields.META_FIELD_X_OAS_MAX_LENGTH]: options.maxLength
      });
    }
    schema.type = 'string';
    super(schema, options);
  }
  handleError(type, {
    limit,
    value
  }) {
    switch (type) {
      case 'any.required':
        return `expected value of type [string] but got [${(0, _typeDetect.default)(value)}]`;
      case 'string.hostname':
        return `value must be a valid hostname (see RFC 1123).`;
    }
  }
}
exports.StringType = StringType;