"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.writeCasesPermissions = exports.writeCasesCapabilities = exports.readCasesPermissions = exports.readCasesCapabilities = exports.onlyReopenCasesPermission = exports.onlyDeleteCasesPermission = exports.onlyCreateCommentPermissions = exports.noUpdateCasesPermissions = exports.noReopenCasesPermissions = exports.noPushCasesPermissions = exports.noDeleteCasesPermissions = exports.noCreateCommentCasesPermissions = exports.noCreateCasesPermissions = exports.noConnectorsCasePermission = exports.noCasesSettingsPermission = exports.noCasesPermissions = exports.noCasesCapabilities = exports.noAssignCasesPermissions = exports.disabledReopenCasePermission = exports.buildCasesPermissions = exports.buildCasesCapabilities = exports.allCasesPermissions = exports.allCasesCapabilities = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const allCasesPermissions = () => buildCasesPermissions();
exports.allCasesPermissions = allCasesPermissions;
const noCasesPermissions = () => buildCasesPermissions({
  read: false,
  create: false,
  update: false,
  delete: false,
  push: false,
  connectors: false,
  settings: false,
  createComment: false,
  reopenCase: false,
  assign: false
});
exports.noCasesPermissions = noCasesPermissions;
const readCasesPermissions = () => buildCasesPermissions({
  read: true,
  create: false,
  update: false,
  delete: false,
  push: false,
  connectors: true,
  settings: false,
  createComment: false,
  reopenCase: false,
  assign: false
});
exports.readCasesPermissions = readCasesPermissions;
const noCreateCasesPermissions = () => buildCasesPermissions({
  create: false
});
exports.noCreateCasesPermissions = noCreateCasesPermissions;
const noCreateCommentCasesPermissions = () => buildCasesPermissions({
  createComment: false
});
exports.noCreateCommentCasesPermissions = noCreateCommentCasesPermissions;
const noUpdateCasesPermissions = () => buildCasesPermissions({
  update: false,
  reopenCase: false
});
exports.noUpdateCasesPermissions = noUpdateCasesPermissions;
const noAssignCasesPermissions = () => buildCasesPermissions({
  assign: false
});
exports.noAssignCasesPermissions = noAssignCasesPermissions;
const noPushCasesPermissions = () => buildCasesPermissions({
  push: false
});
exports.noPushCasesPermissions = noPushCasesPermissions;
const noDeleteCasesPermissions = () => buildCasesPermissions({
  delete: false
});
exports.noDeleteCasesPermissions = noDeleteCasesPermissions;
const noReopenCasesPermissions = () => buildCasesPermissions({
  reopenCase: false
});
exports.noReopenCasesPermissions = noReopenCasesPermissions;
const writeCasesPermissions = () => buildCasesPermissions({
  read: false
});
exports.writeCasesPermissions = writeCasesPermissions;
const onlyCreateCommentPermissions = () => buildCasesPermissions({
  read: false,
  create: false,
  update: false,
  delete: true,
  push: false,
  createComment: true,
  reopenCase: false,
  assign: false
});
exports.onlyCreateCommentPermissions = onlyCreateCommentPermissions;
const onlyDeleteCasesPermission = () => buildCasesPermissions({
  read: false,
  create: false,
  update: false,
  delete: true,
  push: false,
  createComment: false,
  reopenCase: false,
  assign: false
});
// In practice, a real life user should never have this configuration, but testing for thoroughness
exports.onlyDeleteCasesPermission = onlyDeleteCasesPermission;
const onlyReopenCasesPermission = () => buildCasesPermissions({
  read: false,
  create: false,
  update: false,
  delete: false,
  push: false,
  createComment: false,
  reopenCase: true,
  assign: false
});
exports.onlyReopenCasesPermission = onlyReopenCasesPermission;
const noConnectorsCasePermission = () => buildCasesPermissions({
  connectors: false
});
exports.noConnectorsCasePermission = noConnectorsCasePermission;
const noCasesSettingsPermission = () => buildCasesPermissions({
  settings: false
});
exports.noCasesSettingsPermission = noCasesSettingsPermission;
const disabledReopenCasePermission = () => buildCasesPermissions({
  reopenCase: false
});
exports.disabledReopenCasePermission = disabledReopenCasePermission;
const buildCasesPermissions = (overrides = {}) => {
  var _overrides$create, _overrides$read, _overrides$update, _overrides$delete, _overrides$push, _overrides$connectors, _overrides$settings, _overrides$reopenCase, _overrides$createComm, _overrides$assign;
  const create = (_overrides$create = overrides.create) !== null && _overrides$create !== void 0 ? _overrides$create : true;
  const read = (_overrides$read = overrides.read) !== null && _overrides$read !== void 0 ? _overrides$read : true;
  const update = (_overrides$update = overrides.update) !== null && _overrides$update !== void 0 ? _overrides$update : true;
  const deletePermissions = (_overrides$delete = overrides.delete) !== null && _overrides$delete !== void 0 ? _overrides$delete : true;
  const push = (_overrides$push = overrides.push) !== null && _overrides$push !== void 0 ? _overrides$push : true;
  const connectors = (_overrides$connectors = overrides.connectors) !== null && _overrides$connectors !== void 0 ? _overrides$connectors : true;
  const settings = (_overrides$settings = overrides.settings) !== null && _overrides$settings !== void 0 ? _overrides$settings : true;
  const reopenCase = (_overrides$reopenCase = overrides.reopenCase) !== null && _overrides$reopenCase !== void 0 ? _overrides$reopenCase : true;
  const createComment = (_overrides$createComm = overrides.createComment) !== null && _overrides$createComm !== void 0 ? _overrides$createComm : true;
  const assign = (_overrides$assign = overrides.assign) !== null && _overrides$assign !== void 0 ? _overrides$assign : true;
  const all = create && read && update && deletePermissions && push && settings && connectors && reopenCase && assign && createComment;
  return {
    all,
    create,
    read,
    update,
    delete: deletePermissions,
    push,
    connectors,
    settings,
    reopenCase,
    createComment,
    assign
  };
};
exports.buildCasesPermissions = buildCasesPermissions;
const allCasesCapabilities = () => buildCasesCapabilities();
exports.allCasesCapabilities = allCasesCapabilities;
const noCasesCapabilities = () => buildCasesCapabilities({
  create_cases: false,
  read_cases: false,
  update_cases: false,
  delete_cases: false,
  push_cases: false,
  cases_connectors: false,
  cases_settings: false,
  create_comment: false,
  case_reopen: false,
  cases_assign: false
});
exports.noCasesCapabilities = noCasesCapabilities;
const readCasesCapabilities = () => buildCasesCapabilities({
  create_cases: false,
  update_cases: false,
  delete_cases: false,
  push_cases: false,
  cases_settings: false,
  create_comment: false,
  case_reopen: false,
  cases_assign: false
});
exports.readCasesCapabilities = readCasesCapabilities;
const writeCasesCapabilities = () => {
  return buildCasesCapabilities({
    read_cases: false
  });
};
exports.writeCasesCapabilities = writeCasesCapabilities;
const buildCasesCapabilities = overrides => {
  var _overrides$create_cas, _overrides$read_cases, _overrides$update_cas, _overrides$delete_cas, _overrides$push_cases, _overrides$cases_conn, _overrides$cases_sett, _overrides$create_com, _overrides$case_reope, _overrides$cases_assi;
  return {
    create_cases: (_overrides$create_cas = overrides === null || overrides === void 0 ? void 0 : overrides.create_cases) !== null && _overrides$create_cas !== void 0 ? _overrides$create_cas : true,
    read_cases: (_overrides$read_cases = overrides === null || overrides === void 0 ? void 0 : overrides.read_cases) !== null && _overrides$read_cases !== void 0 ? _overrides$read_cases : true,
    update_cases: (_overrides$update_cas = overrides === null || overrides === void 0 ? void 0 : overrides.update_cases) !== null && _overrides$update_cas !== void 0 ? _overrides$update_cas : true,
    delete_cases: (_overrides$delete_cas = overrides === null || overrides === void 0 ? void 0 : overrides.delete_cases) !== null && _overrides$delete_cas !== void 0 ? _overrides$delete_cas : true,
    push_cases: (_overrides$push_cases = overrides === null || overrides === void 0 ? void 0 : overrides.push_cases) !== null && _overrides$push_cases !== void 0 ? _overrides$push_cases : true,
    cases_connectors: (_overrides$cases_conn = overrides === null || overrides === void 0 ? void 0 : overrides.cases_connectors) !== null && _overrides$cases_conn !== void 0 ? _overrides$cases_conn : true,
    cases_settings: (_overrides$cases_sett = overrides === null || overrides === void 0 ? void 0 : overrides.cases_settings) !== null && _overrides$cases_sett !== void 0 ? _overrides$cases_sett : true,
    create_comment: (_overrides$create_com = overrides === null || overrides === void 0 ? void 0 : overrides.create_comment) !== null && _overrides$create_com !== void 0 ? _overrides$create_com : true,
    case_reopen: (_overrides$case_reope = overrides === null || overrides === void 0 ? void 0 : overrides.case_reopen) !== null && _overrides$case_reope !== void 0 ? _overrides$case_reope : true,
    cases_assign: (_overrides$cases_assi = overrides === null || overrides === void 0 ? void 0 : overrides.cases_assign) !== null && _overrides$cases_assi !== void 0 ? _overrides$cases_assi : true
  };
};
exports.buildCasesCapabilities = buildCasesCapabilities;