"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createOpenTelemetryAgentInstructions = void 0;
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _api_key_callout = require("./api_key_callout");
var _agent_status_instructions = require("../agent_status_instructions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createOpenTelemetryAgentInstructions = commonOptions => {
  const {
    apmServerUrl,
    otlpManagedServiceUrl,
    apiKeyDetails,
    checkAgentStatus,
    agentStatus,
    agentStatusLoading
  } = commonOptions;
  return [{
    title: _i18n.i18n.translate('xpack.apm.onboarding.otel.download.title', {
      defaultMessage: 'Instrument your app with OpenTelemetry SDK'
    }),
    children: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.apm.onboarding.otel.download.textPre",
      defaultMessage: "For guidance on downloading and getting started with the OpenTelemetry SDK or Elastic Distribution of OpenTelemetry (EDOT) SDK, either review the {openTelemetryDocLink} or see the {edotDocLink}.",
      values: {
        openTelemetryDocLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "apmCreateOpenTelemetryAgentInstructionsOpenTelemetryDocumentationLink",
          target: "_blank",
          href: "https://opentelemetry.io/docs/instrumentation"
        }, _i18n.i18n.translate('xpack.apm.createOpenTelemetryAgentInstructions.openTelemetryDocumentationLinkLabel', {
          defaultMessage: 'OpenTelemetry documentation'
        })),
        edotDocLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "apmCreateOpenTelemetryAgentInstructionsEDOTDocsLink",
          target: "_blank",
          href: "http://ela.st/edot-sdks"
        }, _i18n.i18n.translate('xpack.apm.createOpenTelemetryAgentInstructions.EDOTDocumentationLinkLabel', {
          defaultMessage: 'EDOT documentation'
        }))
      }
    }))
  }, {
    title: _i18n.i18n.translate('xpack.apm.onboarding.otel.configureAgent.title', {
      defaultMessage: 'Configure the OpenTelemetry SDK'
    }),
    children: /*#__PURE__*/_react.default.createElement(ConfigureSDKInstructions, {
      apmServerUrl: apmServerUrl,
      otlpManagedServiceUrl: otlpManagedServiceUrl,
      apiKeyDetails: apiKeyDetails
    })
  }, (0, _agent_status_instructions.agentStatusCheckInstruction)({
    checkAgentStatus,
    agentStatus,
    agentStatusLoading
  })];
};
exports.createOpenTelemetryAgentInstructions = createOpenTelemetryAgentInstructions;
function ConfigurationValueColumn({
  setting,
  value,
  createApiKey,
  createApiKeyLoading,
  apiKey
}) {
  const shouldRenderCreateApiKeyButton = setting === 'OTEL_EXPORTER_OTLP_HEADERS' && apiKey === null;
  if (shouldRenderCreateApiKeyButton) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "createApiKeyAndId",
      fill: true,
      onClick: createApiKey,
      isLoading: createApiKeyLoading
    }, _i18n.i18n.translate('xpack.apm.onboarding.apiKey.create', {
      defaultMessage: 'Create API Key'
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "accent"
  }, value), value && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "apmConfigurationValueColumnButton",
    "aria-label": _i18n.i18n.translate('xpack.apm.onboarding.otel.column.value.copyIconText', {
      defaultMessage: 'Copy to clipboard'
    }),
    color: "text",
    iconType: "copy",
    onClick: () => (0, _eui.copyToClipboard)(value)
  }));
}
function ConfigureSDKInstructions({
  otlpManagedServiceUrl,
  apmServerUrl,
  apiKeyDetails
}) {
  const [selectedOptionId, setSelectedOptionId] = (0, _react.useState)('apm');
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: "Default single select button group",
    options: [{
      id: 'apm',
      label: 'Classic APM Endpoint'
    }, {
      id: 'otlp',
      label: 'Managed OTLP Endpoint',
      iconType: 'beaker',
      iconSide: 'right',
      toolTipContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.apm.onboarding.otel.managedOtlpEndpointTooltip",
        defaultMessage: "This functionality is in Tech Preview."
      }),
      toolTipProps: {
        position: 'right'
      }
    }],
    idSelected: selectedOptionId,
    onChange: id => setSelectedOptionId(id)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), selectedOptionId === 'apm' ? /*#__PURE__*/_react.default.createElement(ClassicAPMEndpointInstructions, {
    apmServerUrl: apmServerUrl,
    apiKeyDetails: apiKeyDetails
  }) : /*#__PURE__*/_react.default.createElement(ManagedOTLPEndpointInstructions, {
    otlpManagedServiceUrl: otlpManagedServiceUrl,
    apiKeyDetails: apiKeyDetails
  }));
}
function ClassicAPMEndpointInstructions({
  apmServerUrl,
  apiKeyDetails
}) {
  const authHeaderValue = `Authorization=ApiKey ${apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.apiKey}`;
  const items = [{
    setting: 'OTEL_EXPORTER_OTLP_ENDPOINT',
    value: apmServerUrl ? apmServerUrl : '<apm-managed-service-url>'
  }, {
    setting: 'OTEL_EXPORTER_OTLP_HEADERS',
    value: authHeaderValue,
    apiKey: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.apiKey
  }, {
    setting: 'OTEL_METRICS_EXPORTER',
    value: 'otlp',
    notes: 'Enable metrics when supported by your OpenTelemetry client.'
  }, {
    setting: 'OTEL_LOGS_EXPORTER',
    value: 'otlp',
    notes: 'Enable logs when supported by your OpenTelemetry client'
  }, {
    setting: 'OTEL_RESOURCE_ATTRIBUTES',
    value: 'service.name=<app-name>,service.version=<app-version>,deployment.environment=production'
  }];
  const columns = [{
    field: 'setting',
    width: '23%',
    name: _i18n.i18n.translate('xpack.apm.onboarding.config_classic_otel.column.configSettings', {
      defaultMessage: 'Configuration setting'
    })
  }, {
    field: 'value',
    width: '55%',
    name: _i18n.i18n.translate('xpack.apm.onboarding.config_classic_otel.column.configValue', {
      defaultMessage: 'Configuration value'
    }),
    render: (_, {
      value,
      setting,
      apiKey
    }) => /*#__PURE__*/_react.default.createElement(ConfigurationValueColumn, {
      setting: setting,
      value: value,
      createApiKey: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.createAgentKey,
      createApiKeyLoading: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.createApiKeyLoading,
      apiKey: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.apiKey
    })
  }, {
    field: 'notes',
    name: _i18n.i18n.translate('xpack.apm.onboarding.config_classic_otel.column.notes', {
      defaultMessage: 'Notes'
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, null, _i18n.i18n.translate('xpack.apm.onboarding.otel.configureSDK.classic.description', {
    defaultMessage: 'The Classic APM Endpoint translates OpenTelemetry semantic conventions into ECS format prior to storage. Specify the following OpenTelemetry settings as part of the startup of your application.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), ((apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.displayApiKeySuccessCallout) || (apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.displayApiKeyErrorCallout)) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_api_key_callout.ApiKeyCallout, {
    isError: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.displayApiKeyErrorCallout,
    isSuccess: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.displayApiKeySuccessCallout,
    errorMessage: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.errorMessage
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: items,
    columns: columns,
    "data-test-subj": "otel-instructions-table"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(InstructionsFooter, null));
}
function ManagedOTLPEndpointInstructions({
  otlpManagedServiceUrl,
  apiKeyDetails
}) {
  const authHeaderValue = `Authorization=ApiKey ${apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.apiKey}`;
  const items = [{
    setting: 'OTEL_EXPORTER_OTLP_ENDPOINT',
    value: otlpManagedServiceUrl ? otlpManagedServiceUrl : '<otlp-managed-service-url>'
  }, {
    setting: 'OTEL_EXPORTER_OTLP_HEADERS',
    value: authHeaderValue,
    apiKey: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.apiKey
  }, {
    setting: 'OTEL_RESOURCE_ATTRIBUTES',
    value: 'service.name=<app-name>,service.version=<app-version>,deployment.environment=production'
  }];
  const columns = [{
    field: 'setting',
    width: '23%',
    name: _i18n.i18n.translate('xpack.apm.onboarding.config_otel.column.configSettings', {
      defaultMessage: 'Configuration setting'
    })
  }, {
    field: 'value',
    width: '55%',
    name: _i18n.i18n.translate('xpack.apm.onboarding.config_otel.column.configValue', {
      defaultMessage: 'Configuration value'
    }),
    render: (_, {
      value,
      setting,
      apiKey
    }) => /*#__PURE__*/_react.default.createElement(ConfigurationValueColumn, {
      setting: setting,
      value: value,
      createApiKey: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.createAgentKey,
      createApiKeyLoading: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.createApiKeyLoading,
      apiKey: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.apiKey
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, null, _i18n.i18n.translate('xpack.apm.onboarding.otel.configureAgent.textPre', {
    defaultMessage: 'The Managed OTLP Endpoint provides native support for handling of log, metric, and trace data from OpenTelemetry sources. It preserves OpenTelemetry semantic conventions and resource attributes, offering a native experience aligned with OpenTelemetry standards. Managed OTLP endpoint is currently in **Technical Preview.** Specify the following OpenTelemetry settings as part of the startup of your application.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), ((apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.displayApiKeySuccessCallout) || (apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.displayApiKeyErrorCallout)) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_api_key_callout.ApiKeyCallout, {
    isError: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.displayApiKeyErrorCallout,
    isSuccess: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.displayApiKeySuccessCallout,
    errorMessage: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.errorMessage
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: items,
    columns: columns,
    "data-test-subj": "otel-instructions-table"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(InstructionsFooter, null));
}
function InstructionsFooter() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.apm.onboarding.config_otel.description1",
    defaultMessage: "OpenTelemetry agents and SDKs must support the {otelExporterOtlpEndpoint}, {otelExporterOtlpHeaders}, and {otelResourceAttributes} variables; some unstable components may not yet comply with this requirement.",
    values: {
      otelExporterOtlpEndpoint: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "apmOpenTelemetryInstructionsOtelExporterOtlpEndpointLink",
        target: "_blank",
        href: "https://ela.st/otel-spec-exporter-doc"
        // eslint-disable-next-line @kbn/i18n/strings_should_be_translated_with_i18n
      }, "OTEL_EXPORTER_OTLP_ENDPOINT"),
      otelExporterOtlpHeaders: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "apmOpenTelemetryInstructionsOtelExporterOtlpHeadersLink",
        target: "_blank",
        href: "https://ela.st/otel-spec-exporter-doc"
        // eslint-disable-next-line @kbn/i18n/strings_should_be_translated_with_i18n
      }, "OTEL_EXPORTER_OTLP_HEADERS"),
      otelResourceAttributes: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "apmOpenTelemetryInstructionsOtelResourceAttributesLink",
        target: "_blank",
        href: "https://ela.st/otel-spec-sdk"
        // eslint-disable-next-line @kbn/i18n/strings_should_be_translated_with_i18n
      }, "OTEL_RESOURCE_ATTRIBUTES")
    }
  }));
}