"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformResponse = void 0;
var _transforms = require("../../../../transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformResponse = results => {
  return results.map(result => {
    if (result !== null && result !== void 0 && result.error) {
      return result;
    }
    return (0, _transforms.transformBackfillToBackfillResponseV1)(result);
  });
};
exports.transformResponse = transformResponse;