"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataGridColumnSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _popover = require("../../popover");
var _i18n = require("../../i18n");
var _button = require("../../button");
var _flex = require("../../flex");
var _form = require("../../form");
var _text = require("../../text");
var _icon = require("../../icon");
var _drag_and_drop = require("../../drag_and_drop");
var _data_grid_toolbar = require("./data_grid_toolbar");
var _data_grid_toolbar_control = require("./data_grid_toolbar_control");
var _column_selector = require("./column_selector.styles");
var _react2 = require("@emotion/react");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var useDataGridColumnSelector = exports.useDataGridColumnSelector = function useDataGridColumnSelector(availableColumns, columnVisibility, showColumnSelector, displayValues) {
  var allowColumnHiding = (0, _data_grid_toolbar.getNestedObjectOptions)(showColumnSelector, 'allowHide');
  var allowColumnReorder = (0, _data_grid_toolbar.getNestedObjectOptions)(showColumnSelector, 'allowReorder');
  var _useDependentState = (0, _services.useDependentState)(function () {
      return availableColumns.map(function (_ref) {
        var id = _ref.id;
        return id;
      });
    }, [availableColumns]),
    _useDependentState2 = _slicedToArray(_useDependentState, 2),
    sortedColumns = _useDependentState2[0],
    setSortedColumns = _useDependentState2[1];
  var visibleColumns = columnVisibility.visibleColumns,
    setVisibleColumns = columnVisibility.setVisibleColumns;
  var visibleColumnIds = (0, _react.useMemo)(function () {
    return new Set(visibleColumns);
  }, [visibleColumns]);
  var _useState = (0, _react.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    isOpen = _useState2[0],
    setIsOpen = _useState2[1];
  var setColumns = (0, _react.useCallback)(function (nextColumns) {
    setSortedColumns(nextColumns);
    var nextVisibleColumns = nextColumns.filter(function (id) {
      return visibleColumnIds.has(id);
    });
    setVisibleColumns(nextVisibleColumns);
  }, [setSortedColumns, setVisibleColumns, visibleColumnIds]);
  var onDragEnd = (0, _react.useCallback)(function (_ref2) {
    var sourceIndex = _ref2.source.index,
      destination = _ref2.destination;
    if (destination) {
      var destinationIndex = destination.index;
      var nextSortedColumns = (0, _drag_and_drop.euiDragDropReorder)(sortedColumns, sourceIndex, destinationIndex);
      setColumns(nextSortedColumns);
    }
  }, [sortedColumns, setColumns]);
  var numberOfHiddenFields = availableColumns.length - visibleColumns.length;
  var _useState3 = (0, _react.useState)(''),
    _useState4 = _slicedToArray(_useState3, 2),
    columnSearchText = _useState4[0],
    setColumnSearchText = _useState4[1];
  var filteredColumns = (0, _react.useMemo)(function () {
    return sortedColumns.filter(function (id) {
      return (displayValues[id] || id).toLowerCase().indexOf(columnSearchText.toLowerCase()) !== -1;
    });
  }, [sortedColumns, columnSearchText, displayValues]);
  var isDragEnabled = allowColumnReorder && columnSearchText.length === 0; // only allow drag-and-drop when not filtering columns
  var dragHandleAriaLabel = (0, _i18n.useEuiI18n)('euiColumnSelector.dragHandleAriaLabel', 'Drag handle');
  var orderedVisibleColumns = (0, _react.useMemo)(function () {
    return visibleColumns.map(function (columnId) {
      return availableColumns.find(function (_ref3) {
        var id = _ref3.id;
        return id === columnId;
      });
    } // cast to avoid `undefined`, it filters those out next
    ).filter(function (column) {
      return column != null;
    });
  }, [availableColumns, visibleColumns]);
  var styles = (0, _services.useEuiMemoizedStyles)(_column_selector.euiDataGridColumnSelectorStyles);
  var columnSelector = (0, _react.useMemo)(function () {
    return allowColumnHiding || allowColumnReorder ? (0, _react2.jsx)(_popover.EuiPopover, {
      "data-test-subj": "dataGridColumnSelectorPopover",
      isOpen: isOpen,
      closePopover: function closePopover() {
        return setIsOpen(false);
      },
      anchorPosition: "downLeft",
      panelPaddingSize: "none",
      button: (0, _react2.jsx)(_data_grid_toolbar_control.EuiDataGridToolbarControl, {
        badgeContent: numberOfHiddenFields > 0 ? "".concat(orderedVisibleColumns.length, "/").concat(availableColumns.length) : availableColumns.length,
        iconType: "tableDensityNormal",
        "data-test-subj": "dataGridColumnSelectorButton",
        onClick: function onClick() {
          return setIsOpen(!isOpen);
        }
      }, (0, _react2.jsx)(_i18n.EuiI18n, {
        token: "euiColumnSelector.button",
        default: "Columns"
      }))
    }, allowColumnHiding && (0, _react2.jsx)(_popover.EuiPopoverTitle, {
      paddingSize: "s"
    }, (0, _react2.jsx)(_i18n.EuiI18n, {
      tokens: ['euiColumnSelector.search', 'euiColumnSelector.searchcolumns'],
      defaults: ['Search', 'Search columns']
    }, function (_ref4) {
      var _ref5 = _slicedToArray(_ref4, 2),
        search = _ref5[0],
        searchcolumns = _ref5[1];
      return (0, _react2.jsx)(_form.EuiFieldText, {
        compressed: true,
        placeholder: search,
        "aria-label": searchcolumns,
        value: columnSearchText,
        onChange: function onChange(e) {
          return setColumnSearchText(e.currentTarget.value);
        },
        "data-test-subj": "dataGridColumnSelectorSearch"
      });
    })), (0, _react2.jsx)(_drag_and_drop.EuiDragDropContext, {
      onDragEnd: onDragEnd
    }, (0, _react2.jsx)(_drag_and_drop.EuiDroppable, {
      droppableId: "columnOrder",
      isDropDisabled: !isDragEnabled,
      css: styles.euiDataGridColumnSelector
    }, (0, _react2.jsx)(_react.default.Fragment, null, filteredColumns.map(function (id, index) {
      return (0, _react2.jsx)(_drag_and_drop.EuiDraggable, {
        key: id,
        draggableId: id,
        index: index,
        isDragDisabled: !isDragEnabled,
        hasInteractiveChildren: true,
        customDragHandle: true,
        usePortal: true
      }, function (provided, state) {
        return (0, _react2.jsx)("div", {
          css: styles.euiDataGridColumnSelector__item,
          className: (0, _classnames.default)('euiDataGridColumnSelector__item', {
            'euiDataGridColumnSelector__item-isDragging': state.isDragging
          }),
          "data-test-subj": "dataGridColumnSelectorColumnItem-".concat(id)
        }, (0, _react2.jsx)(_flex.EuiFlexGroup, {
          responsive: false,
          gutterSize: "s",
          alignItems: "center"
        }, allowColumnHiding && (0, _react2.jsx)(_flex.EuiFlexItem, {
          grow: false
        }, (0, _react2.jsx)(_form.EuiSwitch, {
          name: id,
          label: displayValues[id] || id,
          showLabel: false,
          checked: visibleColumnIds.has(id),
          mini: true,
          onChange: function onChange(event) {
            var checked = event.target.checked;
            var nextVisibleColumns = sortedColumns.filter(function (columnId) {
              return checked ? visibleColumnIds.has(columnId) || id === columnId : visibleColumnIds.has(columnId) && id !== columnId;
            });
            setVisibleColumns(nextVisibleColumns);
          },
          "data-test-subj": "dataGridColumnSelectorToggleColumnVisibility-".concat(id)
        })), (0, _react2.jsx)(_flex.EuiFlexItem
        // This extra column name flex item affords the column more grabbable real estate
        // for mouse users, while hiding repetition for keyboard/screen reader users
        , _extends({}, provided.dragHandleProps, {
          "aria-hidden": true,
          tabIndex: -1
        }), (0, _react2.jsx)(_text.EuiText, {
          size: "xs",
          className: "euiDataGridColumnSelector__itemLabel"
        }, displayValues[id] || id)), isDragEnabled && (0, _react2.jsx)(_flex.EuiFlexItem, _extends({
          grow: false
        }, provided.dragHandleProps, {
          "aria-label": dragHandleAriaLabel
        }), (0, _react2.jsx)(_icon.EuiIcon, {
          type: "grab",
          color: "subdued"
        }))));
      });
    })))), allowColumnHiding && (0, _react2.jsx)(_popover.EuiPopoverFooter, {
      paddingSize: "s"
    }, (0, _react2.jsx)(_flex.EuiFlexGroup, {
      gutterSize: "s",
      responsive: false,
      justifyContent: "spaceBetween"
    }, (0, _react2.jsx)(_flex.EuiFlexItem, {
      grow: false
    }, (0, _react2.jsx)(_button.EuiButtonEmpty, {
      size: "xs",
      flush: "left",
      onClick: function onClick() {
        return setVisibleColumns(sortedColumns);
      },
      "data-test-subj": "dataGridColumnSelectorShowAllButton"
    }, (0, _react2.jsx)(_i18n.EuiI18n, {
      token: "euiColumnSelector.selectAll",
      default: "Show all"
    }))), (0, _react2.jsx)(_flex.EuiFlexItem, {
      grow: false
    }, (0, _react2.jsx)(_button.EuiButtonEmpty, {
      size: "xs",
      flush: "right",
      onClick: function onClick() {
        return setVisibleColumns([]);
      },
      "data-test-subj": "dataGridColumnSelectorHideAllButton"
    }, (0, _react2.jsx)(_i18n.EuiI18n, {
      token: "euiColumnSelector.hideAll",
      default: "Hide all"
    })))))) : null;
  }, [styles, availableColumns.length, numberOfHiddenFields, orderedVisibleColumns.length, allowColumnHiding, allowColumnReorder, isOpen, columnSearchText, displayValues, visibleColumnIds, sortedColumns, setVisibleColumns, setIsOpen, onDragEnd, isDragEnabled, dragHandleAriaLabel, filteredColumns]);

  /**
   * Used for moving columns left/right, available in the headers actions menu
   */
  var switchColumnPos = (0, _react.useCallback)(function (fromColId, toColId) {
    var moveFromIdx = sortedColumns.indexOf(fromColId);
    var moveToIdx = sortedColumns.indexOf(toColId);
    if (moveFromIdx === -1 || moveToIdx === -1) {
      return;
    }
    var nextSortedColumns = _toConsumableArray(sortedColumns);
    nextSortedColumns.splice(moveFromIdx, 1);
    nextSortedColumns.splice(moveToIdx, 0, fromColId);
    setColumns(nextSortedColumns);
  }, [setColumns, sortedColumns]);
  return (0, _react.useMemo)(function () {
    return [columnSelector, orderedVisibleColumns, setVisibleColumns, switchColumnPos];
  }, [columnSelector, orderedVisibleColumns, setVisibleColumns, switchColumnPos]);
};