"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.excess = void 0;
var tslib_1 = require("tslib");
// Extra IO-TS type to not allow more keys than the defined ones.
// Extracted from https://github.com/gcanti/io-ts/issues/322
var t = tslib_1.__importStar(require("io-ts"));
var Either_1 = require("fp-ts/lib/Either");
var getIsCodec = function (tag) {
    return function (codec) {
        return codec._tag === tag;
    };
};
var isInterfaceCodec = getIsCodec('InterfaceType');
var isPartialCodec = getIsCodec('PartialType');
var isIntersectionType = getIsCodec('IntersectionType');
var getProps = function (codec) {
    switch (codec._tag) {
        case 'RefinementType':
        case 'ReadonlyType':
            return getProps(codec.type);
        case 'InterfaceType':
        case 'StrictType':
        case 'PartialType':
            return codec.props;
        case 'IntersectionType':
            return codec.types.reduce(function (props, type) { return Object.assign(props, getProps(type)); }, {});
    }
};
var getNameFromProps = function (props, isPartial) {
    return Object.keys(props)
        .map(function (k) { return "".concat(k).concat(isPartial ? '?' : '', ": ").concat(props[k].name); })
        .join(', ');
};
/**
 * Provides a human-readable definition of the io-ts validator.
 * @param codec The io-ts declaration passed as an argument to the Excess method.
 * @remarks Since we currently use it only with objects, we'll cover the IntersectionType and PartialType
 */
var getExcessTypeName = function (codec) {
    if (isIntersectionType(codec)) {
        return "{ ".concat(codec.types
            .map(function (subCodec) {
            if (isInterfaceCodec(subCodec)) {
                return getNameFromProps(subCodec.props, false);
            }
            if (isPartialCodec(subCodec)) {
                return getNameFromProps(subCodec.props, true);
            }
            return subCodec.name;
        })
            .filter(Boolean)
            .join(', '), " }");
    }
    return "Excess<".concat(codec.name, ">");
};
var stripKeys = function (o, props) {
    var keys = Object.getOwnPropertyNames(o);
    var propsKeys = Object.getOwnPropertyNames(props);
    propsKeys.forEach(function (pk) {
        var index = keys.indexOf(pk);
        if (index !== -1) {
            keys.splice(index, 1);
        }
    });
    return keys.length ? (0, Either_1.left)(keys) : (0, Either_1.right)(o);
};
/**
 * Validate if there are any keys that exist in the validated object, but they don't in the validation object.
 * @param codec The io-ts schema to wrap with this validation
 * @param name (optional) Replace the custom logic to name the validation error by providing a static name.
 */
var excess = function (codec, name) {
    if (name === void 0) { name = getExcessTypeName(codec); }
    var props = getProps(codec);
    return new ExcessType(name, function (u) { return (0, Either_1.isRight)(stripKeys(u, props)) && codec.is(u); }, function (u, c) {
        return Either_1.either.chain(t.UnknownRecord.validate(u, c), function () {
            return Either_1.either.chain(codec.validate(u, c), function (a) {
                return Either_1.either.mapLeft(stripKeys(a, props), function (keys) {
                    return keys.map(function (k) { return ({
                        value: a[k],
                        context: c,
                        message: "excess key '".concat(k, "' found"),
                    }); });
                });
            });
        });
    }, function (a) { return codec.encode(stripKeys(a, props).right); }, codec);
};
exports.excess = excess;
var ExcessType = /** @class */ (function (_super) {
    tslib_1.__extends(ExcessType, _super);
    function ExcessType(name, is, validate, encode, type) {
        var _this = _super.call(this, name, is, validate, encode) || this;
        _this.type = type;
        _this._tag = 'ExcessType';
        return _this;
    }
    return ExcessType;
}(t.Type));
