"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WarningCheckbox = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WarningCheckbox = ({
  isChecked,
  warningId,
  label,
  onChange,
  description,
  dataStreamName
}) => /*#__PURE__*/_react.default.createElement("div", {
  "data-test-subj": "migrationWarningCheckbox"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
  id: warningId,
  checkableType: "checkbox",
  checked: isChecked,
  onChange: onChange,
  label: label
}, dataStreamName && /*#__PURE__*/_react.default.createElement("p", null, "Data stream: ", /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, dataStreamName)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s"
}), description));
exports.WarningCheckbox = WarningCheckbox;