"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.strings = exports.QueryBarMenuPanel = void 0;
exports.useQueryBarMenuPanels = useQueryBarMenuPanels;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _esQuery = require("@kbn/es-query");
var _i18n = require("@kbn/i18n");
var _analytics = require("@kbn/analytics");
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("@kbn/data-plugin/common");
var _uiTheme = require("@kbn/ui-theme");
var _from_user = require("./from_user");
var _language_switcher = require("./language_switcher");
var _panel_title = require("./panel_title");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const MAP_ITEMS_TO_FILTER_OPTION = {
  'filter-sets-pinAllFilters': 'pinFilter',
  'filter-sets-unpinAllFilters': 'pinFilter',
  'filter-sets-enableAllFilters': 'disableFilter',
  'filter-sets-disableAllFilters': 'disableFilter',
  'filter-sets-invertAllFilters': 'negateFilter',
  'filter-sets-removeAllFilters': 'deleteFilter'
};
const strings = exports.strings = {
  getLuceneLanguageName: () => _i18n.i18n.translate('unifiedSearch.query.queryBar.luceneLanguageName', {
    defaultMessage: 'Lucene'
  }),
  getKqlLanguageName: () => _i18n.i18n.translate('unifiedSearch.query.queryBar.kqlLanguageName', {
    defaultMessage: 'KQL'
  }),
  getOptionsAddFilterButtonLabel: () => _i18n.i18n.translate('unifiedSearch.filter.options.addFilterButtonLabel', {
    defaultMessage: 'Add filter'
  }),
  getOptionsApplyAllFiltersButtonLabel: () => _i18n.i18n.translate('unifiedSearch.filter.options.applyAllFiltersButtonLabel', {
    defaultMessage: 'Apply to all'
  }),
  getLoadOtherFilterSetLabel: () => _i18n.i18n.translate('unifiedSearch.filter.options.loadOtherFilterSetLabel', {
    defaultMessage: 'Load query'
  }),
  getLoadCurrentFilterSetLabel: () => _i18n.i18n.translate('unifiedSearch.filter.options.loadCurrentFilterSetLabel', {
    defaultMessage: 'Load query'
  }),
  getSaveAsNewFilterSetLabel: () => _i18n.i18n.translate('unifiedSearch.filter.options.saveAsNewFilterSetLabel', {
    defaultMessage: 'Save query'
  }),
  getSaveFilterSetLabel: () => _i18n.i18n.translate('unifiedSearch.filter.options.saveFilterSetLabel', {
    defaultMessage: 'Save query'
  }),
  getClearAllFiltersButtonLabel: () => _i18n.i18n.translate('unifiedSearch.filter.options.clearllFiltersButtonLabel', {
    defaultMessage: 'Clear all'
  }),
  getSavedQueryPopoverSaveChangesButtonAriaLabel: title => _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryPopoverSaveChangesButtonAriaLabel', {
    defaultMessage: 'Save changes to {title}',
    values: {
      title
    }
  }),
  getSavedQueryPopoverSaveChangesButtonText: () => _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryPopoverSaveChangesButtonText', {
    defaultMessage: 'Update query'
  }),
  getSavedQueryPopoverSaveAsNewButtonAriaLabel: () => _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryPopoverSaveAsNewButtonAriaLabel', {
    defaultMessage: 'Save as new query'
  }),
  getSavedQueryPopoverSaveAsNewButtonText: () => _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryPopoverSaveAsNewButtonText', {
    defaultMessage: 'Save as new'
  }),
  getSaveCurrentFilterSetLabel: () => _i18n.i18n.translate('unifiedSearch.filter.options.saveCurrentFilterSetLabel', {
    defaultMessage: 'Save as new'
  }),
  getApplyAllFiltersButtonLabel: () => _i18n.i18n.translate('unifiedSearch.filter.options.applyAllFiltersButtonLabel', {
    defaultMessage: 'Apply to all'
  }),
  getEnableAllFiltersButtonLabel: () => _i18n.i18n.translate('unifiedSearch.filter.options.enableAllFiltersButtonLabel', {
    defaultMessage: 'Enable all'
  }),
  getDisableAllFiltersButtonLabel: () => _i18n.i18n.translate('unifiedSearch.filter.options.disableAllFiltersButtonLabel', {
    defaultMessage: 'Disable all'
  }),
  getInvertNegatedFiltersButtonLabel: () => _i18n.i18n.translate('unifiedSearch.filter.options.invertNegatedFiltersButtonLabel', {
    defaultMessage: 'Invert inclusion'
  }),
  getPinAllFiltersButtonLabel: () => _i18n.i18n.translate('unifiedSearch.filter.options.pinAllFiltersButtonLabel', {
    defaultMessage: 'Pin all'
  }),
  getUnpinAllFiltersButtonLabel: () => _i18n.i18n.translate('unifiedSearch.filter.options.unpinAllFiltersButtonLabel', {
    defaultMessage: 'Unpin all'
  }),
  getFilterLanguageLabel: () => _i18n.i18n.translate('unifiedSearch.filter.options.filterLanguageLabel', {
    defaultMessage: 'Filter language'
  }),
  getQuickFiltersLabel: () => _i18n.i18n.translate('unifiedSearch.filter.options.quickFiltersLabel', {
    defaultMessage: 'Quick filters'
  })
};
let QueryBarMenuPanel = exports.QueryBarMenuPanel = /*#__PURE__*/function (QueryBarMenuPanel) {
  QueryBarMenuPanel["main"] = "main";
  QueryBarMenuPanel["applyToAllFilters"] = "applyToAllFilters";
  QueryBarMenuPanel["updateCurrentQuery"] = "updateCurrentQuery";
  QueryBarMenuPanel["saveAsNewQuery"] = "saveAsNewQuery";
  QueryBarMenuPanel["loadQuery"] = "loadQuery";
  QueryBarMenuPanel["selectLanguage"] = "selectLanguage";
  return QueryBarMenuPanel;
}({});
function useQueryBarMenuPanels({
  filters,
  additionalQueryBarMenuItems,
  savedQuery,
  language,
  dateRangeFrom,
  dateRangeTo,
  timeFilter,
  query,
  showSaveQuery,
  showSavedQueryControls = true,
  showFilterBar,
  showQueryInput,
  savedQueryService,
  saveFormComponent,
  saveAsNewQueryFormComponent,
  manageFilterSetComponent,
  hiddenPanelOptions,
  nonKqlMode,
  disableQueryLanguageSwitcher = false,
  queryBarMenuRef,
  closePopover,
  onQueryBarSubmit,
  onFiltersUpdated,
  onClearSavedQuery,
  onQueryChange,
  setRenderedComponent
}) {
  var _application$capabili, _additionalQueryBarMe, _additionalQueryBarMe2;
  const kibana = (0, _public.useKibana)();
  const {
    appName,
    usageCollection,
    uiSettings,
    http,
    storage,
    application
  } = kibana.services;
  const reportUiCounter = usageCollection === null || usageCollection === void 0 ? void 0 : usageCollection.reportUiCounter.bind(usageCollection, appName);
  const showSavedQueries = showSavedQueryControls && showQueryInput && showFilterBar && ((_application$capabili = application.capabilities.savedQueryManagement) === null || _application$capabili === void 0 ? void 0 : _application$capabili.showQueries);
  const cancelPendingListingRequest = (0, _react.useRef)(() => {});
  const [hasSavedQueries, setHasSavedQueries] = (0, _react.useState)(false);
  const [hasFiltersOrQuery, setHasFiltersOrQuery] = (0, _react.useState)(false);
  const [savedQueryHasChanged, setSavedQueryHasChanged] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (savedQuery) {
      cancelPendingListingRequest.current();
      setHasSavedQueries(true);
    }
  }, [savedQuery]);
  (0, _react.useEffect)(() => {
    const fetchSavedQueries = async () => {
      cancelPendingListingRequest.current();
      let requestGotCancelled = false;
      cancelPendingListingRequest.current = () => {
        requestGotCancelled = true;
      };
      const queryCount = await savedQueryService.getSavedQueryCount();
      if (requestGotCancelled) return;
      setHasSavedQueries(queryCount > 0);
    };
    if (showSavedQueries) {
      fetchSavedQueries();
    }
  }, [savedQueryService, showSavedQueries]);
  (0, _react.useEffect)(() => {
    if (savedQuery) {
      var _savedQuery$attribute;
      const filtersHaveChanged = !(0, _esQuery.compareFilters)(filters !== null && filters !== void 0 ? filters : [], (_savedQuery$attribute = savedQuery.attributes.filters) !== null && _savedQuery$attribute !== void 0 ? _savedQuery$attribute : [], _esQuery.COMPARE_ALL_OPTIONS);
      const timeFilterHasChanged = Boolean((savedQuery === null || savedQuery === void 0 ? void 0 : savedQuery.attributes.timefilter) && !(0, _lodash.isEqual)(timeFilter, savedQuery === null || savedQuery === void 0 ? void 0 : savedQuery.attributes.timefilter));
      if (filtersHaveChanged || timeFilterHasChanged || !(0, _lodash.isEqual)(query, savedQuery === null || savedQuery === void 0 ? void 0 : savedQuery.attributes.query)) {
        setSavedQueryHasChanged(true);
      } else {
        setSavedQueryHasChanged(false);
      }
    }
  }, [filters, query, savedQuery, timeFilter]);
  (0, _react.useEffect)(() => {
    const hasFilters = Boolean(filters && filters.length > 0);
    const hasQuery = Boolean(query && query.query);
    setHasFiltersOrQuery(hasFilters || hasQuery);
  }, [filters, onClearSavedQuery, query, savedQuery]);
  const getDateRange = () => {
    const defaultTimeSetting = uiSettings.get(_common.UI_SETTINGS.TIMEPICKER_TIME_DEFAULTS);
    return {
      from: dateRangeFrom || defaultTimeSetting.from,
      to: dateRangeTo || defaultTimeSetting.to
    };
  };
  const onEnableAll = () => {
    reportUiCounter === null || reportUiCounter === void 0 ? void 0 : reportUiCounter(_analytics.METRIC_TYPE.CLICK, `filter:enable_all`);
    const enabledFilters = filters === null || filters === void 0 ? void 0 : filters.map(_esQuery.enableFilter);
    if (enabledFilters) {
      onFiltersUpdated === null || onFiltersUpdated === void 0 ? void 0 : onFiltersUpdated(enabledFilters);
    }
  };
  const onDisableAll = () => {
    reportUiCounter === null || reportUiCounter === void 0 ? void 0 : reportUiCounter(_analytics.METRIC_TYPE.CLICK, `filter:disable_all`);
    const disabledFilters = filters === null || filters === void 0 ? void 0 : filters.map(_esQuery.disableFilter);
    if (disabledFilters) {
      onFiltersUpdated === null || onFiltersUpdated === void 0 ? void 0 : onFiltersUpdated(disabledFilters);
    }
  };
  const onToggleAllNegated = () => {
    reportUiCounter === null || reportUiCounter === void 0 ? void 0 : reportUiCounter(_analytics.METRIC_TYPE.CLICK, `filter:invert_all`);
    const negatedFilters = filters === null || filters === void 0 ? void 0 : filters.map(_esQuery.toggleFilterNegated);
    if (negatedFilters) {
      onFiltersUpdated === null || onFiltersUpdated === void 0 ? void 0 : onFiltersUpdated(negatedFilters);
    }
  };
  const onRemoveAll = () => {
    reportUiCounter === null || reportUiCounter === void 0 ? void 0 : reportUiCounter(_analytics.METRIC_TYPE.CLICK, `filter:remove_all`);
    onFiltersUpdated === null || onFiltersUpdated === void 0 ? void 0 : onFiltersUpdated([]);
  };
  const onPinAll = () => {
    reportUiCounter === null || reportUiCounter === void 0 ? void 0 : reportUiCounter(_analytics.METRIC_TYPE.CLICK, `filter:pin_all`);
    const pinnedFilters = filters === null || filters === void 0 ? void 0 : filters.map(_esQuery.pinFilter);
    if (pinnedFilters) {
      onFiltersUpdated === null || onFiltersUpdated === void 0 ? void 0 : onFiltersUpdated(pinnedFilters);
    }
  };
  const onUnpinAll = () => {
    reportUiCounter === null || reportUiCounter === void 0 ? void 0 : reportUiCounter(_analytics.METRIC_TYPE.CLICK, `filter:unpin_all`);
    const unPinnedFilters = filters === null || filters === void 0 ? void 0 : filters.map(_esQuery.unpinFilter);
    if (unPinnedFilters) {
      onFiltersUpdated === null || onFiltersUpdated === void 0 ? void 0 : onFiltersUpdated(unPinnedFilters);
    }
  };
  const onQueryStringChange = value => {
    onQueryChange({
      query: {
        query: value,
        language
      },
      dateRange: getDateRange()
    });
  };
  const onSelectLanguage = lang => {
    http.post('/internal/kql_opt_in_stats', {
      version: _common.KQL_TELEMETRY_ROUTE_LATEST_VERSION,
      body: JSON.stringify({
        opt_in: lang === 'kuery'
      })
    });
    const storageKey = _common.KIBANA_USER_QUERY_LANGUAGE_KEY;
    storage.set(storageKey, lang);
    const newQuery = {
      query: '',
      language: lang
    };
    onQueryStringChange(newQuery.query);
    onQueryBarSubmit({
      query: {
        query: (0, _from_user.fromUser)(newQuery.query),
        language: newQuery.language
      },
      dateRange: getDateRange()
    });
  };
  const luceneLabel = strings.getLuceneLanguageName();
  const kqlLabel = strings.getKqlLanguageName();
  const filtersRelatedPanels = [{
    name: strings.getOptionsAddFilterButtonLabel(),
    icon: 'plus',
    onClick: () => {
      setRenderedComponent('addFilter');
    }
  }, {
    name: strings.getOptionsApplyAllFiltersButtonLabel(),
    icon: 'filter',
    panel: QueryBarMenuPanel.applyToAllFilters,
    disabled: !Boolean(filters && filters.length > 0),
    'data-test-subj': 'filter-sets-applyToAllFilters'
  }];
  const queryAndFiltersRelatedPanels = [{
    name: savedQuery ? strings.getLoadOtherFilterSetLabel() : strings.getLoadCurrentFilterSetLabel(),
    panel: QueryBarMenuPanel.loadQuery,
    icon: 'filter',
    'data-test-subj': 'saved-query-management-load-button',
    disabled: !hasSavedQueries || !Boolean(manageFilterSetComponent)
  }, {
    name: savedQuery ? strings.getSaveAsNewFilterSetLabel() : strings.getSaveFilterSetLabel(),
    icon: 'save',
    disabled: !Boolean(showSaveQuery) || !hasFiltersOrQuery || savedQuery && !savedQueryHasChanged,
    panel: QueryBarMenuPanel.saveAsNewQuery,
    'data-test-subj': 'saved-query-management-save-button'
  }, {
    isSeparator: true
  }];
  const items = [];
  // apply to all actions are only shown when there are filters
  if (showFilterBar) {
    items.push(...filtersRelatedPanels);
  }
  // clear all actions are only shown when there are filters or query
  if (showFilterBar || showQueryInput) {
    items.push({
      name: strings.getClearAllFiltersButtonLabel(),
      disabled: !hasFiltersOrQuery && !Boolean(savedQuery),
      icon: 'cross',
      'data-test-subj': 'filter-sets-removeAllFilters',
      onClick: () => {
        closePopover();
        onQueryBarSubmit({
          query: {
            query: '',
            language
          },
          dateRange: getDateRange()
        });
        onRemoveAll();
        onClearSavedQuery === null || onClearSavedQuery === void 0 ? void 0 : onClearSavedQuery();
      }
    }, {
      isSeparator: true
    });
  }
  if (showFilterBar && (_additionalQueryBarMe = additionalQueryBarMenuItems.items) !== null && _additionalQueryBarMe !== void 0 && _additionalQueryBarMe.length) {
    items.push(...[...additionalQueryBarMenuItems.items, {
      isSeparator: true
    }]);
  }

  // saved queries actions are only shown when the showQueryInput and showFilterBar is true
  if (showSavedQueries) {
    items.push(...queryAndFiltersRelatedPanels);
  }

  // language menu appears when the showQueryInput is true
  if (showQueryInput && !disableQueryLanguageSwitcher) {
    items.push({
      name: `Language: ${language === 'kuery' ? kqlLabel : luceneLabel}`,
      panel: QueryBarMenuPanel.selectLanguage,
      'data-test-subj': 'switchQueryLanguageButton'
    });
  }
  let panels = [{
    id: QueryBarMenuPanel.main,
    title: savedQuery !== null && savedQuery !== void 0 && savedQuery.attributes.title ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: savedQuery ? 'primary' : 'default',
      size: "s",
      "data-test-subj": "savedQueryTitle"
    }, /*#__PURE__*/_react.default.createElement("strong", null, savedQuery.attributes.title))), savedQuery && savedQueryHasChanged && Boolean(showSaveQuery) && hasFiltersOrQuery && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      fill: true,
      onClick: () => {
        var _queryBarMenuRef$curr;
        (_queryBarMenuRef$curr = queryBarMenuRef.current) === null || _queryBarMenuRef$curr === void 0 ? void 0 : _queryBarMenuRef$curr.showPanel(QueryBarMenuPanel.updateCurrentQuery, 'next');
      },
      "aria-label": strings.getSavedQueryPopoverSaveChangesButtonAriaLabel(savedQuery === null || savedQuery === void 0 ? void 0 : savedQuery.attributes.title),
      "data-test-subj": "saved-query-management-save-changes-button"
    }, strings.getSavedQueryPopoverSaveChangesButtonText())))) : undefined,
    items
  }, {
    id: QueryBarMenuPanel.applyToAllFilters,
    initialFocusedItemIndex: 1,
    title: strings.getApplyAllFiltersButtonLabel(),
    items: [{
      name: strings.getEnableAllFiltersButtonLabel(),
      icon: 'eye',
      'data-test-subj': 'filter-sets-enableAllFilters',
      onClick: () => {
        closePopover();
        onEnableAll();
      }
    }, {
      name: strings.getDisableAllFiltersButtonLabel(),
      'data-test-subj': 'filter-sets-disableAllFilters',
      icon: 'eyeClosed',
      onClick: () => {
        closePopover();
        onDisableAll();
      }
    }, {
      name: strings.getInvertNegatedFiltersButtonLabel(),
      'data-test-subj': 'filter-sets-invertAllFilters',
      icon: 'invert',
      onClick: () => {
        closePopover();
        onToggleAllNegated();
      }
    }, {
      name: strings.getPinAllFiltersButtonLabel(),
      'data-test-subj': 'filter-sets-pinAllFilters',
      icon: 'pin',
      onClick: () => {
        closePopover();
        onPinAll();
      }
    }, {
      name: strings.getUnpinAllFiltersButtonLabel(),
      'data-test-subj': 'filter-sets-unpinAllFilters',
      icon: 'pin',
      onClick: () => {
        closePopover();
        onUnpinAll();
      }
    }]
  }, {
    id: QueryBarMenuPanel.updateCurrentQuery,
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_panel_title.PanelTitle, {
      queryBarMenuRef: queryBarMenuRef,
      title: strings.getSavedQueryPopoverSaveChangesButtonText()
    }), /*#__PURE__*/_react.default.createElement("div", {
      css: {
        padding: _uiTheme.euiThemeVars.euiSizeM
      }
    }, saveFormComponent))
  }, {
    id: QueryBarMenuPanel.saveAsNewQuery,
    title: strings.getSaveCurrentFilterSetLabel(),
    content: /*#__PURE__*/_react.default.createElement("div", {
      css: {
        padding: _uiTheme.euiThemeVars.euiSizeM
      }
    }, saveAsNewQueryFormComponent)
  }, {
    id: QueryBarMenuPanel.loadQuery,
    width: 400,
    content: /*#__PURE__*/_react.default.createElement("div", null, manageFilterSetComponent)
  }, {
    id: QueryBarMenuPanel.selectLanguage,
    title: strings.getFilterLanguageLabel(),
    content: /*#__PURE__*/_react.default.createElement(_language_switcher.QueryLanguageSwitcher, {
      language: language,
      onSelectLanguage: onSelectLanguage,
      nonKqlMode: nonKqlMode,
      isOnTopBarMenu: true,
      deps: {
        docLinks: kibana.services.docLinks
      }
    })
  }, {
    id: 4,
    title: strings.getLoadCurrentFilterSetLabel(),
    width: 400,
    content: /*#__PURE__*/_react.default.createElement("div", null, manageFilterSetComponent)
  }, ...((_additionalQueryBarMe2 = additionalQueryBarMenuItems.panels) !== null && _additionalQueryBarMe2 !== void 0 ? _additionalQueryBarMe2 : [])];
  if (hiddenPanelOptions && hiddenPanelOptions.length > 0) {
    panels = panels.map(panel => {
      var _panel$items;
      return {
        ...panel,
        items: (_panel$items = panel.items) === null || _panel$items === void 0 ? void 0 : _panel$items.filter(panelItem => {
          if (!panelItem['data-test-subj']) {
            return true;
          }
          const panelFilterOption = MAP_ITEMS_TO_FILTER_OPTION[panelItem['data-test-subj']];
          if (!panelFilterOption) {
            return true;
          }
          return !hiddenPanelOptions.includes(panelFilterOption);
        })
      };
    });
  }
  return panels;
}