"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setUnifiedDocViewerServices = exports.getUnifiedDocViewerServices = exports.UnifiedDocViewerPublicPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _unifiedDocViewer = require("@kbn/unified-doc-viewer");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-utils-plugin/public");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const [getUnifiedDocViewerServices, setUnifiedDocViewerServices] = (0, _public.createGetterSetter)('UnifiedDocViewerServices');
exports.setUnifiedDocViewerServices = setUnifiedDocViewerServices;
exports.getUnifiedDocViewerServices = getUnifiedDocViewerServices;
const fallback = /*#__PURE__*/_react.default.createElement(_eui.EuiDelayRender, {
  delay: 300
}, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, null));
const LazyDocViewerTable = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./components/doc_viewer_table'))), {
  fallback
});
const LazySourceViewer = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./components/doc_viewer_source'))), {
  fallback
});
class UnifiedDocViewerPublicPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "docViewsRegistry", new _unifiedDocViewer.DocViewsRegistry());
  }
  setup(core) {
    this.docViewsRegistry.add({
      id: 'doc_view_table',
      title: _i18n.i18n.translate('unifiedDocViewer.docViews.table.tableTitle', {
        defaultMessage: 'Table'
      }),
      order: 10,
      component: props => {
        return /*#__PURE__*/_react.default.createElement(LazyDocViewerTable, props);
      }
    });
    this.docViewsRegistry.add({
      id: 'doc_view_source',
      title: _i18n.i18n.translate('unifiedDocViewer.docViews.json.jsonTitle', {
        defaultMessage: 'JSON'
      }),
      order: 20,
      component: ({
        hit,
        dataView,
        textBasedHits,
        decreaseAvailableHeightBy
      }) => {
        var _hit$raw$_id;
        return /*#__PURE__*/_react.default.createElement(LazySourceViewer, {
          index: hit.raw._index,
          id: (_hit$raw$_id = hit.raw._id) !== null && _hit$raw$_id !== void 0 ? _hit$raw$_id : hit.id,
          dataView: dataView
          // If ES|QL query changes, then textBasedHits will update too.
          // This is a workaround to reuse the previously referred hit
          // so the doc viewer preserves the state even after the record disappears from hits list.
          ,
          esqlHit: Array.isArray(textBasedHits) ? hit : undefined,
          decreaseAvailableHeightBy: decreaseAvailableHeightBy,
          onRefresh: () => {}
        });
      }
    });
    return {
      registry: this.docViewsRegistry
    };
  }
  start(core, deps) {
    const {
      analytics,
      uiSettings,
      notifications: {
        toasts
      }
    } = core;
    const {
      data,
      fieldFormats,
      fieldsMetadata,
      share
    } = deps;
    const storage = new _public.Storage(localStorage);
    const unifiedDocViewer = {
      registry: this.docViewsRegistry
    };
    const services = {
      analytics,
      data,
      fieldFormats,
      fieldsMetadata,
      toasts,
      storage,
      uiSettings,
      unifiedDocViewer,
      share,
      core
    };
    setUnifiedDocViewerServices(services);
    return unifiedDocViewer;
  }
}
exports.UnifiedDocViewerPublicPlugin = UnifiedDocViewerPublicPlugin;