"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpanSummaryTitle = void 0;
var _eui = require("@elastic/eui");
var _discoverUtils = require("@kbn/discover-utils");
var _react = _interopRequireDefault(require("react"));
var _field_hover_popover_action = require("../../components/field_with_actions/field_hover_popover_action");
var _highlight_field = require("../../components/highlight_field.tsx");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const SpanSummaryTitle = ({
  spanName,
  spanId,
  formattedSpanId,
  formattedSpanName,
  showActions = true
}) => {
  const FieldContent = ({
    children,
    field,
    title,
    value
  }) => {
    return showActions ? /*#__PURE__*/_react.default.createElement(_field_hover_popover_action.FieldHoverActionPopover, {
      title: title,
      value: value,
      field: field
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children)) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
  };
  return spanName ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(FieldContent, {
    title: spanName,
    value: spanName,
    field: _discoverUtils.SPAN_NAME_FIELD,
    showActions: showActions
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
    textSize: "m",
    value: spanName,
    formattedValue: formattedSpanName,
    as: "strong"
  }))))), /*#__PURE__*/_react.default.createElement(FieldContent, {
    title: spanId,
    value: spanId,
    field: _discoverUtils.SPAN_ID_FIELD,
    showActions: showActions
  }, /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
    value: spanId,
    formattedValue: formattedSpanId
  }))) : /*#__PURE__*/_react.default.createElement(FieldContent, {
    title: spanId,
    value: spanId,
    field: _discoverUtils.SPAN_ID_FIELD,
    showActions: showActions
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
    value: spanId,
    formattedValue: formattedSpanId,
    as: "h2"
  })));
};
exports.SpanSummaryTitle = SpanSummaryTitle;