"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpanSummaryField = SpanSummaryField;
var _discoverUtils = require("@kbn/discover-utils");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _field_with_actions = require("../../components/field_with_actions/field_with_actions");
var _use_root_span = require("../hooks/use_root_span");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function SpanSummaryField({
  fieldConfiguration,
  fieldId,
  fieldMapping,
  showActions = true
}) {
  const {
    trace,
    loading
  } = (0, _use_root_span.useRootSpanContext)();
  const [fieldValue, setFieldValue] = (0, _react.useState)(fieldConfiguration.value);
  const isTransactionNameField = fieldId === _discoverUtils.TRANSACTION_NAME_FIELD;
  const isTransactionNameFieldWithoutValue = isTransactionNameField && !fieldValue;
  (0, _react.useEffect)(() => {
    if (isTransactionNameField && !fieldValue && trace !== null && trace !== void 0 && trace.name && !loading) {
      setFieldValue(trace.name);
    }
  }, [trace === null || trace === void 0 ? void 0 : trace.name, loading, fieldValue, isTransactionNameField]);
  if (!isTransactionNameFieldWithoutValue && !fieldValue || isTransactionNameFieldWithoutValue && !loading) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_field_with_actions.FieldWithActions, {
    "data-test-subj": `unifiedDocViewerObservabilityTracesAttribute-${fieldId}`,
    label: fieldConfiguration.title,
    field: fieldId,
    value: fieldValue,
    formattedValue: fieldValue,
    fieldMapping: fieldMapping,
    fieldMetadata: fieldConfiguration.fieldMetadata,
    loading: isTransactionNameFieldWithoutValue && loading,
    showActions: showActions
  }, /*#__PURE__*/_react.default.createElement("div", null, fieldConfiguration.content(fieldValue, fieldConfiguration.formattedValue))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }));
}