"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpanOverview = SpanOverview;
var _eui = require("@elastic/eui");
var _discoverUtils = require("@kbn/discover-utils");
var _src = require("@kbn/discover-utils/src");
var _react = _interopRequireWildcard(require("react"));
var _use_field_actions = require("../../../../hooks/use_field_actions");
var _use_data_view_fields = require("../../../../hooks/use_data_view_fields");
var _plugin = require("../../../../plugin");
var _trace = require("../components/trace");
var _use_root_span = require("./hooks/use_root_span");
var _fields = require("./resources/fields");
var _get_span_field_configuration = require("./resources/get_span_field_configuration");
var _span_duration_summary = require("./sub_components/span_duration_summary");
var _span_summary_field = require("./sub_components/span_summary_field");
var _span_summary_title = require("./sub_components/span_summary_title");
var _use_root_transaction = require("../doc_viewer_transaction_overview/hooks/use_root_transaction");
var _use_data_sources = require("../hooks/use_data_sources");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function SpanOverview({
  columns,
  hit,
  filter,
  onAddColumn,
  onRemoveColumn,
  indexes,
  showWaterfall = true,
  showActions = true,
  dataView,
  columnsMeta
}) {
  const {
    fieldFormats
  } = (0, _plugin.getUnifiedDocViewerServices)();
  const {
    formattedDoc,
    flattenedDoc
  } = (0, _react.useMemo)(() => ({
    formattedDoc: (0, _discoverUtils.getSpanDocumentOverview)(hit, {
      dataView,
      fieldFormats
    }),
    flattenedDoc: (0, _src.getFlattenedSpanDocumentOverview)(hit)
  }), [dataView, fieldFormats, hit]);
  const {
    dataViewFields
  } = (0, _use_data_view_fields.useDataViewFields)({
    fields: _fields.allSpanFields,
    dataView,
    columnsMeta
  });
  const fieldConfigurations = (0, _react.useMemo)(() => (0, _get_span_field_configuration.getSpanFieldConfiguration)({
    attributes: formattedDoc,
    flattenedDoc
  }), [formattedDoc, flattenedDoc]);
  const isOtelSpan = flattenedDoc[_discoverUtils.SPAN_DURATION_FIELD] == null && flattenedDoc[_discoverUtils.OTEL_DURATION] != null;
  const spanDuration = isOtelSpan ? flattenedDoc[_discoverUtils.OTEL_DURATION] * 0.001 : flattenedDoc[_discoverUtils.SPAN_DURATION_FIELD];
  const traceId = flattenedDoc[_discoverUtils.TRACE_ID_FIELD];
  const transactionId = flattenedDoc[_discoverUtils.TRANSACTION_ID_FIELD];
  return /*#__PURE__*/_react.default.createElement(_use_data_sources.DataSourcesProvider, {
    indexes: indexes
  }, /*#__PURE__*/_react.default.createElement(_use_root_transaction.RootTransactionProvider, {
    traceId: traceId,
    indexPattern: indexes.apm.traces
  }, /*#__PURE__*/_react.default.createElement(_use_root_span.RootSpanProvider, {
    traceId: traceId,
    transactionId: transactionId,
    indexPattern: indexes.apm.traces
  }, /*#__PURE__*/_react.default.createElement(_use_field_actions.FieldActionsProvider, {
    columns: columns,
    filter: filter,
    onAddColumn: onAddColumn,
    onRemoveColumn: onRemoveColumn
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    hasShadow: false,
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_span_summary_title.SpanSummaryTitle, {
    spanName: flattenedDoc[_discoverUtils.SPAN_NAME_FIELD],
    formattedSpanName: formattedDoc[_discoverUtils.SPAN_NAME_FIELD],
    spanId: flattenedDoc[_discoverUtils.SPAN_ID_FIELD],
    formattedSpanId: formattedDoc[_discoverUtils.SPAN_ID_FIELD],
    showActions: showActions
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, _fields.spanFields.map(fieldId => /*#__PURE__*/_react.default.createElement(_span_summary_field.SpanSummaryField, {
    key: fieldId,
    fieldId: fieldId,
    fieldMapping: dataViewFields[fieldId],
    fieldConfiguration: fieldConfigurations[fieldId],
    showActions: showActions
  }))), spanDuration && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_span_duration_summary.SpanDurationSummary, {
    spanDuration: spanDuration,
    spanName: flattenedDoc[_discoverUtils.SPAN_NAME_FIELD],
    serviceName: flattenedDoc[_discoverUtils.SERVICE_NAME_FIELD],
    isOtelSpan: isOtelSpan
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_trace.Trace, {
    fields: fieldConfigurations,
    fieldMappings: dataViewFields,
    traceId: flattenedDoc[_discoverUtils.TRACE_ID_FIELD],
    docId: flattenedDoc[_discoverUtils.SPAN_ID_FIELD],
    displayType: "span",
    dataView: dataView,
    tracesIndexPattern: indexes.apm.traces,
    showWaterfall: showWaterfall,
    showActions: showActions
  }))))))));
}