"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReadOnlyConnectorMessage = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ReadOnlyConnectorMessage = ({
  connectorId,
  connectorName,
  extraComponent,
  href
}) => {
  const ExtraComponent = extraComponent;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.triggersActionsUI.sections.editConnectorForm.descriptionText', {
    defaultMessage: 'This connector is read-only.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "read-only-link",
    href: href,
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.editConnectorForm.preconfiguredHelpLabel",
    defaultMessage: "Learn more about preconfigured connectors."
  })), ExtraComponent && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(ExtraComponent, {
    connectorId: connectorId,
    connectorName: connectorName
  })));
};
exports.ReadOnlyConnectorMessage = ReadOnlyConnectorMessage;