"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.CreateConnectorFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/actions-plugin/common");
var _create_connector_filter = require("./create_connector_filter");
var _capabilities = require("../../../lib/capabilities");
var _kibana = require("../../../../common/lib/kibana");
var _action_type_menu = require("../action_type_menu");
var _use_create_connector = require("../../../hooks/use_create_connector");
var _connector_form = require("../connector_form");
var _header = require("./header");
var _footer = require("./footer");
var _upgrade_license_callout = require("./upgrade_license_callout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CreateConnectorFlyoutComponent = ({
  actionTypeRegistry,
  featureId,
  onClose,
  onConnectorCreated,
  onTestConnector
}) => {
  var _actionType$id, _actionTypeModel$subt;
  const {
    application: {
      capabilities
    }
  } = (0, _kibana.useKibana)().services;
  const {
    isLoading: isSavingConnector,
    createConnector
  } = (0, _use_create_connector.useCreateConnector)();
  const isMounted = (0, _react.useRef)(false);
  const [allActionTypes, setAllActionTypes] = (0, _react.useState)(undefined);
  const [actionType, setActionType] = (0, _react.useState)(null);
  const [hasActionsUpgradeableByTrial, setHasActionsUpgradeableByTrial] = (0, _react.useState)(false);
  const canSave = (0, _capabilities.hasSaveActionsCapability)(capabilities);
  const [showFormErrors, setShowFormErrors] = (0, _react.useState)(false);
  const [searchValue, setSearchValue] = (0, _react.useState)('');
  const [preSubmitValidationErrorMessage, setPreSubmitValidationErrorMessage] = (0, _react.useState)(null);
  const [formState, setFormState] = (0, _react.useState)({
    isSubmitted: false,
    isSubmitting: false,
    isValid: undefined,
    submit: async () => ({
      isValid: false,
      data: {}
    }),
    preSubmitValidator: null
  });
  const initialConnector = {
    actionTypeId: (_actionType$id = actionType === null || actionType === void 0 ? void 0 : actionType.id) !== null && _actionType$id !== void 0 ? _actionType$id : '',
    isDeprecated: false,
    config: {},
    secrets: {},
    isMissingSecrets: false
  };
  const {
    preSubmitValidator,
    submit,
    isValid: isFormValid,
    isSubmitting
  } = formState;
  const hasErrors = isFormValid === false;
  const isSaving = isSavingConnector || isSubmitting;
  const hasConnectorTypeSelected = actionType != null;
  const actionTypeModel = actionType != null ? actionTypeRegistry.get(actionType.id) : null;
  const groupActionTypeModel = actionTypeModel && actionTypeModel.subtype ? ((_actionTypeModel$subt = actionTypeModel === null || actionTypeModel === void 0 ? void 0 : actionTypeModel.subtype) !== null && _actionTypeModel$subt !== void 0 ? _actionTypeModel$subt : []).filter(item => allActionTypes && allActionTypes[item.id].enabledInConfig).map(subtypeAction => ({
    ...actionTypeRegistry.get(subtypeAction.id),
    name: subtypeAction.name
  })) : [];
  const groupActionButtons = (groupActionTypeModel === null || groupActionTypeModel === void 0 ? void 0 : groupActionTypeModel.length) > 1 ? groupActionTypeModel.map(gAction => ({
    id: gAction.id,
    label: gAction.name,
    'data-test-subj': `${gAction.id}Button`
  })) : [];
  const resetConnectorForm = (0, _react.useRef)();
  const setResetForm = reset => {
    resetConnectorForm.current = reset;
    setShowFormErrors(false);
  };
  const onChangeGroupAction = id => {
    if (allActionTypes && allActionTypes[id]) {
      setActionType(allActionTypes[id]);
      if (resetConnectorForm.current) {
        resetConnectorForm.current({
          resetValues: true,
          defaultValue: {
            actionTypeId: id,
            isDeprecated: false,
            config: {},
            secrets: {}
          }
        });
      }
    }
  };
  const validateAndCreateConnector = (0, _react.useCallback)(async () => {
    setPreSubmitValidationErrorMessage(null);
    setShowFormErrors(false);
    const {
      isValid,
      data
    } = await submit();
    if (!isMounted.current) {
      // User has closed the flyout meanwhile submitting the form
      return;
    }
    if (isValid) {
      if (preSubmitValidator) {
        const validatorRes = await preSubmitValidator();
        if (validatorRes) {
          setPreSubmitValidationErrorMessage(validatorRes.message);
          return;
        }
      }

      /**
       * At this point the form is valid
       * and there are no pre submit error messages.
       */

      const {
        actionTypeId,
        name,
        config,
        secrets
      } = data;
      const validConnector = {
        actionTypeId,
        name: name !== null && name !== void 0 ? name : '',
        config: config !== null && config !== void 0 ? config : {},
        secrets: secrets !== null && secrets !== void 0 ? secrets : {}
      };
      const createdConnector = await createConnector(validConnector);
      return createdConnector;
    } else {
      setShowFormErrors(true);
    }
  }, [submit, preSubmitValidator, createConnector]);
  const resetActionType = (0, _react.useCallback)(() => setActionType(null), []);
  const testConnector = (0, _react.useCallback)(async () => {
    const createdConnector = await validateAndCreateConnector();
    if (createdConnector) {
      if (onConnectorCreated) {
        onConnectorCreated(createdConnector);
      }
      if (onTestConnector) {
        onTestConnector(createdConnector);
      }
      onClose();
    }
  }, [validateAndCreateConnector, onClose, onConnectorCreated, onTestConnector]);
  const onSubmit = (0, _react.useCallback)(async () => {
    const createdConnector = await validateAndCreateConnector();
    if (createdConnector) {
      if (onConnectorCreated) {
        onConnectorCreated(createdConnector);
      }
      onClose();
    }
  }, [validateAndCreateConnector, onClose, onConnectorCreated]);
  const handleSearchValueChange = (0, _react.useCallback)(newValue => {
    setSearchValue(newValue);
  }, []);
  (0, _react.useEffect)(() => {
    isMounted.current = true;
    return () => {
      isMounted.current = false;
    };
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    "data-test-subj": "create-connector-flyout",
    "aria-label": _i18n.i18n.translate('xpack.triggersActionsUI.createConnectorFlyout', {
      defaultMessage: 'create connector flyout'
    })
  }, /*#__PURE__*/_react.default.createElement(_header.FlyoutHeader, {
    icon: actionTypeModel === null || actionTypeModel === void 0 ? void 0 : actionTypeModel.iconClass,
    actionTypeName: actionType === null || actionType === void 0 ? void 0 : actionType.name,
    actionTypeMessage: actionTypeModel === null || actionTypeModel === void 0 ? void 0 : actionTypeModel.selectMessage,
    compatibility: (0, _common.getConnectorCompatibility)(actionType === null || actionType === void 0 ? void 0 : actionType.supportedFeatureIds),
    isExperimental: actionTypeModel === null || actionTypeModel === void 0 ? void 0 : actionTypeModel.isExperimental
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    banner: !actionType && hasActionsUpgradeableByTrial ? /*#__PURE__*/_react.default.createElement(_upgrade_license_callout.UpgradeLicenseCallOut, null) : null
  }, !hasConnectorTypeSelected && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_create_connector_filter.CreateConnectorFilter, {
    searchValue: searchValue,
    onSearchValueChange: handleSearchValueChange
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), hasConnectorTypeSelected ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, groupActionTypeModel && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    buttonSize: "m",
    color: "primary",
    legend: "",
    options: groupActionButtons,
    idSelected: actionType.id,
    onChange: onChangeGroupAction,
    "data-test-subj": "slackTypeChangeButton"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  })), showFormErrors && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    color: "danger",
    iconType: "warning",
    "data-test-subj": "connector-form-header-error-label",
    title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionConnectorAdd.headerFormLabel', {
      defaultMessage: 'There are errors in the form'
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_connector_form.ConnectorForm, {
    actionTypeModel: actionTypeModel,
    connector: initialConnector,
    isEdit: false,
    onChange: setFormState,
    setResetForm: setResetForm
  }), !!preSubmitValidationErrorMessage && /*#__PURE__*/_react.default.createElement("p", null, preSubmitValidationErrorMessage), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, onTestConnector && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    "data-test-subj": "create-connector-flyout-save-test-btn",
    type: "submit",
    isLoading: isSaving,
    disabled: hasErrors || !canSave,
    onClick: onTestConnector != null ? testConnector : undefined
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.actionConnectorAdd.saveAndTestButtonLabel",
    defaultMessage: "Save & test"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    color: "primary",
    "data-test-subj": "create-connector-flyout-save-btn",
    type: "submit",
    isLoading: isSaving,
    disabled: hasErrors || !canSave,
    onClick: onSubmit
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.actionConnectorAdd.saveButtonLabel",
    defaultMessage: "Save"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null))))) : /*#__PURE__*/_react.default.createElement(_action_type_menu.ActionTypeMenu, {
    featureId: featureId,
    onActionTypeChange: setActionType,
    setHasActionsUpgradeableByTrial: setHasActionsUpgradeableByTrial,
    setAllActionTypes: setAllActionTypes,
    actionTypeRegistry: actionTypeRegistry,
    searchValue: searchValue
  })), /*#__PURE__*/_react.default.createElement(_footer.FlyoutFooter, {
    hasConnectorTypeSelected: hasConnectorTypeSelected,
    onBack: resetActionType,
    onCancel: onClose
  }));
};
const CreateConnectorFlyout = exports.default = exports.CreateConnectorFlyout = /*#__PURE__*/(0, _react.memo)(CreateConnectorFlyoutComponent);

// eslint-disable-next-line import/no-default-export