"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unmuteRule = unmuteRule;
exports.unmuteRules = unmuteRules;
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function unmuteRule({
  id,
  http
}) {
  await http.post(`${_constants.BASE_ALERTING_API_PATH}/rule/${encodeURIComponent(id)}/_unmute_all`);
}
async function unmuteRules({
  ids,
  http
}) {
  await Promise.all(ids.map(id => unmuteRule({
    id,
    http
  })));
}