"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ALERT_TABLE_GLOBAL_CONFIG_ID = exports.ALERT_TABLE_GENERIC_CONFIG_ID = void 0;
Object.defineProperty(exports, "BASE_ACTION_API_PATH", {
  enumerable: true,
  get: function () {
    return _common2.BASE_ACTION_API_PATH;
  }
});
Object.defineProperty(exports, "BASE_ALERTING_API_PATH", {
  enumerable: true,
  get: function () {
    return _common.BASE_ALERTING_API_PATH;
  }
});
exports.GLOBAL_EXECUTION_DEFAULT_INITIAL_VISIBLE_COLUMNS = exports.GLOBAL_CONNECTOR_EXECUTION_DEFAULT_INITIAL_VISIBLE_COLUMNS = exports.DEFAULT_SEARCH_PAGE_SIZE = exports.DEFAULT_RULE_INTERVAL = exports.DEFAULT_NUMBER_FORMAT = exports.DEFAULT_CONNECTOR_RULES_LIST_PAGE_SIZE = exports.CONNECTOR_LOCKED_COLUMNS = exports.CONNECTOR_EXECUTION_LOG_COLUMN_IDS = void 0;
Object.defineProperty(exports, "INTERNAL_BASE_ACTION_API_PATH", {
  enumerable: true,
  get: function () {
    return _common2.INTERNAL_BASE_ACTION_API_PATH;
  }
});
Object.defineProperty(exports, "INTERNAL_BASE_ALERTING_API_PATH", {
  enumerable: true,
  get: function () {
    return _common.INTERNAL_BASE_ALERTING_API_PATH;
  }
});
exports.SORT_ORDERS = exports.RULE_EXECUTION_LOG_DURATION_COLUMNS = exports.RULE_EXECUTION_LOG_COLUMN_IDS = exports.RULE_EXECUTION_LOG_ALERT_COUNT_COLUMNS = exports.RULE_EXECUTION_DEFAULT_INITIAL_VISIBLE_COLUMNS = exports.MULTI_CONSUMER_RULE_TYPE_IDS = exports.LOCKED_COLUMNS = void 0;
Object.defineProperty(exports, "TIME_UNITS", {
  enumerable: true,
  get: function () {
    return _time_units.TIME_UNITS;
  }
});
exports.summaryMessage = exports.routeToRules = exports.routeToLogs = exports.routeToHome = exports.routeToEditRule = exports.routeToCreateRule = exports.routeToConnectors = exports.routeToConnectorEdit = exports.recoveredActionGroupMessage = exports.legacyRouteToRuleDetails = exports.legacyRouteToAlerts = void 0;
var _i18n = require("@kbn/i18n");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _common = require("@kbn/alerting-plugin/common");
var _common2 = require("@kbn/actions-plugin/common");
var _time_units = require("./time_units");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const routeToHome = exports.routeToHome = `/`;
const routeToConnectors = exports.routeToConnectors = `/connectors`;
const routeToConnectorEdit = exports.routeToConnectorEdit = `/connectors/:connectorId`;
const routeToRules = exports.routeToRules = `/rules`;
const routeToLogs = exports.routeToLogs = `/logs`;
const routeToCreateRule = exports.routeToCreateRule = '/rules/create';
const routeToEditRule = exports.routeToEditRule = '/rules/edit';
const legacyRouteToAlerts = exports.legacyRouteToAlerts = `/alerts`;
const legacyRouteToRuleDetails = exports.legacyRouteToRuleDetails = `/alert/:alertId`;
const recoveredActionGroupMessage = exports.recoveredActionGroupMessage = _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionForm.RecoveredMessage', {
  defaultMessage: 'Recovered'
});
const summaryMessage = exports.summaryMessage = _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionForm.SummaryMessage', {
  defaultMessage: `The system has detected '{{alerts.new.count}}' new, '{{alerts.ongoing.count}}' ongoing, and '{{alerts.recovered.count}}' recovered alerts.`
});
let SORT_ORDERS = exports.SORT_ORDERS = /*#__PURE__*/function (SORT_ORDERS) {
  SORT_ORDERS["ASCENDING"] = "asc";
  SORT_ORDERS["DESCENDING"] = "desc";
  return SORT_ORDERS;
}({});
const DEFAULT_SEARCH_PAGE_SIZE = exports.DEFAULT_SEARCH_PAGE_SIZE = 10;
const DEFAULT_CONNECTOR_RULES_LIST_PAGE_SIZE = exports.DEFAULT_CONNECTOR_RULES_LIST_PAGE_SIZE = 25;
const DEFAULT_RULE_INTERVAL = exports.DEFAULT_RULE_INTERVAL = '1m';
const RULE_EXECUTION_LOG_COLUMN_IDS = exports.RULE_EXECUTION_LOG_COLUMN_IDS = ['rule_id', 'rule_name', 'space_ids', 'id', 'timestamp', 'execution_duration', 'status', 'message', 'num_active_alerts', 'num_new_alerts', 'num_recovered_alerts', 'num_triggered_actions', 'num_generated_actions', 'num_succeeded_actions', 'num_errored_actions', 'total_search_duration', 'es_search_duration', 'schedule_delay', 'timed_out', 'maintenance_window_ids'];
const RULE_EXECUTION_LOG_DURATION_COLUMNS = exports.RULE_EXECUTION_LOG_DURATION_COLUMNS = ['execution_duration', 'total_search_duration', 'es_search_duration', 'schedule_delay'];
const RULE_EXECUTION_LOG_ALERT_COUNT_COLUMNS = exports.RULE_EXECUTION_LOG_ALERT_COUNT_COLUMNS = ['num_new_alerts', 'num_active_alerts', 'num_recovered_alerts'];
const LOCKED_COLUMNS = exports.LOCKED_COLUMNS = ['rule_name', 'timestamp', 'execution_duration', 'status', 'message', 'num_active_alerts', 'num_errored_actions'];
const RULE_EXECUTION_DEFAULT_INITIAL_VISIBLE_COLUMNS = exports.RULE_EXECUTION_DEFAULT_INITIAL_VISIBLE_COLUMNS = [...LOCKED_COLUMNS.slice(1)];
const GLOBAL_EXECUTION_DEFAULT_INITIAL_VISIBLE_COLUMNS = exports.GLOBAL_EXECUTION_DEFAULT_INITIAL_VISIBLE_COLUMNS = ['rule_name', ...LOCKED_COLUMNS.slice(1)];
const DEFAULT_NUMBER_FORMAT = exports.DEFAULT_NUMBER_FORMAT = 'format:number:defaultPattern';
const CONNECTOR_EXECUTION_LOG_COLUMN_IDS = exports.CONNECTOR_EXECUTION_LOG_COLUMN_IDS = ['connector_id', 'space_ids', 'id', 'timestamp', 'status', 'connector_name', 'message', 'execution_duration', 'schedule_delay', 'timed_out'];
const CONNECTOR_LOCKED_COLUMNS = exports.CONNECTOR_LOCKED_COLUMNS = ['timestamp', 'status', 'connector_name', 'message'];
const GLOBAL_CONNECTOR_EXECUTION_DEFAULT_INITIAL_VISIBLE_COLUMNS = exports.GLOBAL_CONNECTOR_EXECUTION_DEFAULT_INITIAL_VISIBLE_COLUMNS = [...CONNECTOR_LOCKED_COLUMNS];
const MULTI_CONSUMER_RULE_TYPE_IDS = exports.MULTI_CONSUMER_RULE_TYPE_IDS = [_ruleDataUtils.OBSERVABILITY_THRESHOLD_RULE_TYPE_ID, _ruleDataUtils.ES_QUERY_ID, _ruleDataUtils.ML_ANOMALY_DETECTION_RULE_TYPE_ID];
const ALERT_TABLE_GENERIC_CONFIG_ID = exports.ALERT_TABLE_GENERIC_CONFIG_ID = `${_ruleDataUtils.AlertConsumers.STACK_ALERTS}-generic-alerts-table`;
const ALERT_TABLE_GLOBAL_CONFIG_ID = exports.ALERT_TABLE_GLOBAL_CONFIG_ID = `${_ruleDataUtils.AlertConsumers.STACK_ALERTS}-global-alerts-table`;