"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepDetailsForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _fieldTypes = require("@kbn/field-types");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _create_data_view_form_row = require("@kbn/ml-data-view-utils/components/create_data_view_form_row");
var _destination_index_form = require("@kbn/ml-creation-wizard-utils/components/destination_index_form");
var _messages = require("../../../../common/validators/messages");
var _constants = require("../../../../../../common/constants");
var _es_utils = require("../../../../../../common/utils/es_utils");
var _errors = require("../../../../../../common/utils/errors");
var _app_dependencies = require("../../../../app_dependencies");
var _components = require("../../../../components");
var _hooks = require("../../../../hooks");
var _common = require("../../../../common");
var _validators = require("../../../../common/validators");
var _common2 = require("./common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StepDetailsForm = exports.StepDetailsForm = /*#__PURE__*/_react.default.memo(({
  overrides = {},
  onChange,
  searchItems,
  stepDefineState
}) => {
  var _esIndicesData$map, _esIngestPipelinesDat, _dataViewTitles$some;
  const {
    application,
    ...startServices
  } = (0, _app_dependencies.useAppDependencies)();
  const {
    capabilities
  } = application;
  const toastNotifications = (0, _app_dependencies.useToastNotifications)();
  const {
    esIndicesCreateIndex
  } = (0, _hooks.useDocumentationLinks)();
  const defaults = {
    ...(0, _common2.getDefaultStepDetailsState)(),
    ...overrides
  };
  const [transformId, setTransformId] = (0, _react.useState)(defaults.transformId);
  const [transformDescription, setTransformDescription] = (0, _react.useState)(defaults.transformDescription);
  const [destinationIndex, setDestinationIndex] = (0, _react.useState)(defaults.destinationIndex);
  const [destIndexSameAsId, setDestIndexSameAsId] = (0, _react.useState)(destinationIndex !== undefined && destinationIndex === transformId);
  const [destinationIngestPipeline, setDestinationIngestPipeline] = (0, _react.useState)(defaults.destinationIngestPipeline);
  const canCreateDataView = (0, _react.useMemo)(() => {
    var _capabilities$savedOb, _capabilities$indexPa;
    return ((_capabilities$savedOb = capabilities.savedObjectsManagement) === null || _capabilities$savedOb === void 0 ? void 0 : _capabilities$savedOb.edit) === true || ((_capabilities$indexPa = capabilities.indexPatterns) === null || _capabilities$indexPa === void 0 ? void 0 : _capabilities$indexPa.save) === true;
  }, [capabilities]);

  // Index pattern state
  const [createDataView, setCreateDataView] = (0, _react.useState)(canCreateDataView === false ? false : defaults.createDataView);
  const [dataViewTimeField, setDataViewTimeField] = (0, _react.useState)();
  const previewRequest = (0, _react.useMemo)(() => {
    const {
      searchQuery,
      previewRequest: partialPreviewRequest
    } = stepDefineState;
    const transformConfigQuery = (0, _common.getTransformConfigQuery)(searchQuery);
    return (0, _common.getPreviewTransformRequestBody)(searchItems.dataView, transformConfigQuery, partialPreviewRequest, stepDefineState.runtimeMappings);
  }, [searchItems.dataView, stepDefineState]);
  const {
    error: transformsPreviewError,
    data: transformPreview
  } = (0, _hooks.useGetTransformsPreview)(previewRequest);
  const destIndexAvailableTimeFields = (0, _react.useMemo)(() => {
    if (!transformPreview) return [];
    const properties = transformPreview.generated_dest_index.mappings.properties;
    const timeFields = Object.keys(properties).filter(col => properties[col].type === 'date');
    return timeFields;
  }, [transformPreview]);
  (0, _react.useEffect)(function resetDataViewTimeField() {
    setDataViewTimeField(destIndexAvailableTimeFields[0]);
  }, [destIndexAvailableTimeFields]);
  const onTimeFieldChanged = _react.default.useCallback(e => {
    const value = e.target.value;
    // If the value is an empty string, it's not a valid selection
    if (value === '') {
      return;
    }
    // Find the time field based on the selected value
    // this is to account for undefined when user chooses not to use a date field
    const timeField = destIndexAvailableTimeFields.find(col => col === value);
    setDataViewTimeField(timeField);
  }, [setDataViewTimeField, destIndexAvailableTimeFields]);
  const {
    error: transformsError,
    data: {
      transformIds
    }
  } = (0, _hooks.useGetTransforms)();
  (0, _react.useEffect)(() => {
    if (transformsError !== null) {
      toastNotifications.addDanger({
        title: _i18n.i18n.translate('xpack.transform.stepDetailsForm.errorGettingTransformList', {
          defaultMessage: 'An error occurred getting the existing transform IDs:'
        }),
        text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_components.ToastNotificationText, {
          text: (0, _errors.getErrorMessage)(transformsError)
        }), startServices)
      });
    }
    // custom comparison
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [transformsError]);
  (0, _react.useEffect)(() => {
    if (transformsPreviewError !== null) {
      toastNotifications.addDanger({
        title: _i18n.i18n.translate('xpack.transform.stepDetailsForm.errorGettingTransformPreview', {
          defaultMessage: 'An error occurred fetching the transform preview'
        }),
        text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_components.ToastNotificationText, {
          text: (0, _errors.getErrorMessage)(transformsPreviewError)
        }), startServices)
      });
    }
    // custom comparison
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [transformsPreviewError]);
  const {
    error: esIndicesError,
    data: esIndicesData
  } = (0, _hooks.useGetEsIndices)();
  const indexNames = (_esIndicesData$map = esIndicesData === null || esIndicesData === void 0 ? void 0 : esIndicesData.map(index => index.name)) !== null && _esIndicesData$map !== void 0 ? _esIndicesData$map : [];
  (0, _react.useEffect)(() => {
    if (esIndicesError !== null) {
      toastNotifications.addDanger({
        title: _i18n.i18n.translate('xpack.transform.stepDetailsForm.errorGettingIndexNames', {
          defaultMessage: 'An error occurred getting the existing index names:'
        }),
        text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_components.ToastNotificationText, {
          text: (0, _errors.getErrorMessage)(esIndicesError)
        }), startServices)
      });
    }
    // custom comparison
    /* eslint-disable react-hooks/exhaustive-deps */
  }, [esIndicesError]);
  const {
    error: esIngestPipelinesError,
    data: esIngestPipelinesData
  } = (0, _hooks.useGetEsIngestPipelines)();
  const ingestPipelineNames = (_esIngestPipelinesDat = esIngestPipelinesData === null || esIngestPipelinesData === void 0 ? void 0 : esIngestPipelinesData.map(({
    name
  }) => name)) !== null && _esIngestPipelinesDat !== void 0 ? _esIngestPipelinesDat : [];
  (0, _react.useEffect)(() => {
    if (esIngestPipelinesError !== null) {
      toastNotifications.addDanger({
        title: _i18n.i18n.translate('xpack.transform.stepDetailsForm.errorGettingIngestPipelines', {
          defaultMessage: 'An error occurred getting the existing ingest pipeline names:'
        }),
        text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_components.ToastNotificationText, {
          text: (0, _errors.getErrorMessage)(esIngestPipelinesError)
        }), startServices)
      });
    }
    // custom comparison
    /* eslint-disable react-hooks/exhaustive-deps */
  }, [esIngestPipelinesError]);
  const {
    error: dataViewTitlesError,
    data: dataViewTitles
  } = (0, _hooks.useGetDataViewTitles)();
  (0, _react.useEffect)(() => {
    if (dataViewTitlesError !== null) {
      toastNotifications.addDanger({
        title: _i18n.i18n.translate('xpack.transform.stepDetailsForm.errorGettingDataViewTitles', {
          defaultMessage: 'An error occurred getting the existing data view titles:'
        }),
        text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_components.ToastNotificationText, {
          text: (0, _errors.getErrorMessage)(dataViewTitlesError)
        }), startServices)
      });
    }
  }, [dataViewTitlesError]);
  const sourceIndexDateFieldNames = searchItems.dataView.fields.filter(f => f.type === _fieldTypes.KBN_FIELD_TYPES.DATE).map(f => f.name).sort();

  // Continuous Mode
  const isContinuousModeAvailable = sourceIndexDateFieldNames.length > 0;
  const [isContinuousModeEnabled, setContinuousModeEnabled] = (0, _react.useState)(defaults.isContinuousModeEnabled);
  const [continuousModeDateField, setContinuousModeDateField] = (0, _react.useState)(isContinuousModeAvailable ? sourceIndexDateFieldNames[0] : '');
  const [continuousModeDelay, setContinuousModeDelay] = (0, _react.useState)(defaults.continuousModeDelay);
  const isContinuousModeDelayValid = (0, _validators.isContinuousModeDelay)(continuousModeDelay);

  // Retention Policy
  const isRetentionPolicyAvailable = destIndexAvailableTimeFields.length > 0;
  const [isRetentionPolicyEnabled, setRetentionPolicyEnabled] = (0, _react.useState)(defaults.isRetentionPolicyEnabled);
  const [retentionPolicyDateField, setRetentionPolicyDateField] = (0, _react.useState)(isRetentionPolicyAvailable ? defaults.retentionPolicyDateField : '');
  const [retentionPolicyMaxAge, setRetentionPolicyMaxAge] = (0, _react.useState)(defaults.retentionPolicyMaxAge);
  const retentionPolicyMaxAgeEmpty = retentionPolicyMaxAge === '';
  const isRetentionPolicyMaxAgeValid = (0, _validators.isRetentionPolicyMaxAge)(retentionPolicyMaxAge);
  (0, _react.useEffect)(() => {
    // Reset retention policy settings when the user disables the whole option
    if (!isRetentionPolicyEnabled) {
      setRetentionPolicyDateField(isRetentionPolicyAvailable ? destIndexAvailableTimeFields[0] : '');
      setRetentionPolicyMaxAge('');
    }

    // When retention policy is first enabled, pick a default option
    if (isRetentionPolicyAvailable && isRetentionPolicyEnabled && retentionPolicyDateField === '') {
      // If a time field '@timestamp' exists, prioritize that
      const prioritizeTimestamp = destIndexAvailableTimeFields.find(d => d === '@timestamp');
      // else pick the first available option
      setRetentionPolicyDateField(prioritizeTimestamp !== null && prioritizeTimestamp !== void 0 ? prioritizeTimestamp : destIndexAvailableTimeFields[0]);
    }
  }, [isRetentionPolicyEnabled, isRetentionPolicyAvailable, destIndexAvailableTimeFields]);
  const transformIdExists = transformIds.some(id => transformId === id);
  const transformIdEmpty = transformId === '';
  const transformIdValid = (0, _common.isTransformIdValid)(transformId);
  const indexNameExists = indexNames.some(name => destinationIndex === name);
  const indexNameEmpty = destinationIndex === '';
  const indexNameValid = (0, _es_utils.isValidIndexName)(destinationIndex);
  const dataViewTitleExists = (_dataViewTitles$some = dataViewTitles === null || dataViewTitles === void 0 ? void 0 : dataViewTitles.some(name => destinationIndex === name)) !== null && _dataViewTitles$some !== void 0 ? _dataViewTitles$some : false;
  const [transformFrequency, setTransformFrequency] = (0, _react.useState)(defaults.transformFrequency);
  const isTransformFrequencyValid = (0, _validators.isTransformWizardFrequency)(transformFrequency);
  const [transformSettingsMaxPageSearchSize, setTransformSettingsMaxPageSearchSize] = (0, _react.useState)(defaults.transformSettingsMaxPageSearchSize);
  const [transformSettingsDocsPerSecond] = (0, _react.useState)(defaults.transformSettingsDocsPerSecond);
  const transformSettingsMaxPageSearchSizeErrors = (0, _validators.transformSettingsPageSearchSizeValidator)(transformSettingsMaxPageSearchSize);
  const isTransformSettingsMaxPageSearchSizeValid = transformSettingsMaxPageSearchSizeErrors.length === 0;
  const [transformSettingsNumFailureRetries, setTransformSettingsNumFailureRetries] = (0, _react.useState)(defaults.transformSettingsNumFailureRetries);
  const isTransformSettingsNumFailureRetriesValid = transformSettingsNumFailureRetries === undefined || transformSettingsNumFailureRetries === '-' || (0, _validators.integerRangeMinus1To100Validator)(transformSettingsNumFailureRetries).length === 0;
  const valid = !transformIdEmpty && transformIdValid && !transformIdExists && isTransformFrequencyValid && isTransformSettingsMaxPageSearchSizeValid && !indexNameEmpty && indexNameValid && (!dataViewTitleExists || !createDataView) && (!isContinuousModeAvailable || isContinuousModeAvailable && isContinuousModeDelayValid) && (!isRetentionPolicyAvailable || !isRetentionPolicyEnabled || isRetentionPolicyAvailable && isRetentionPolicyEnabled && !retentionPolicyMaxAgeEmpty && isRetentionPolicyMaxAgeValid);

  // expose state to wizard
  (0, _react.useEffect)(() => {
    onChange({
      continuousModeDateField,
      continuousModeDelay,
      createDataView,
      isContinuousModeEnabled,
      isRetentionPolicyEnabled,
      retentionPolicyDateField,
      retentionPolicyMaxAge,
      transformId,
      transformDescription,
      transformFrequency,
      transformSettingsMaxPageSearchSize,
      transformSettingsDocsPerSecond,
      transformSettingsNumFailureRetries: transformSettingsNumFailureRetries === undefined || transformSettingsNumFailureRetries === '' ? undefined : typeof transformSettingsNumFailureRetries === 'number' ? transformSettingsNumFailureRetries : parseInt(transformSettingsNumFailureRetries, 10),
      destinationIndex,
      destinationIngestPipeline,
      touched: true,
      valid,
      dataViewTimeField,
      _meta: defaults._meta
    });
    // custom comparison
    /* eslint-disable react-hooks/exhaustive-deps */
  }, [continuousModeDateField, continuousModeDelay, createDataView, isContinuousModeEnabled, isRetentionPolicyEnabled, retentionPolicyDateField, retentionPolicyMaxAge, transformId, transformDescription, transformFrequency, transformSettingsMaxPageSearchSize, transformSettingsNumFailureRetries, destinationIndex, destinationIngestPipeline, valid, dataViewTimeField
  /* eslint-enable react-hooks/exhaustive-deps */]);
  (0, _react.useEffect)(() => {
    if (destIndexSameAsId === true && !transformIdEmpty && transformIdValid) {
      setDestinationIndex(transformId);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [destIndexSameAsId, transformId]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "transformStepDetailsForm"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.transform.stepDetailsForm.transformIdLabel', {
      defaultMessage: 'Transform ID'
    }),
    isInvalid: !transformIdEmpty && !transformIdValid || transformIdExists,
    error: [...(!transformIdEmpty && !transformIdValid ? [_i18n.i18n.translate('xpack.transform.stepDetailsForm.transformIdInvalidError', {
      defaultMessage: 'Must contain lowercase alphanumeric characters (a-z and 0-9), hyphens, and underscores only and must start and end with alphanumeric characters.'
    })] : []), ...(transformIdExists ? [_i18n.i18n.translate('xpack.transform.stepDetailsForm.transformIdExistsError', {
      defaultMessage: 'A transform with this ID already exists.'
    })] : [])]
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: transformId,
    onChange: e => setTransformId(e.target.value),
    "aria-label": _i18n.i18n.translate('xpack.transform.stepDetailsForm.transformIdInputAriaLabel', {
      defaultMessage: 'Choose a unique transform ID.'
    }),
    isInvalid: !transformIdEmpty && !transformIdValid || transformIdExists,
    "data-test-subj": "transformIdInput"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.transform.stepDetailsForm.transformDescriptionLabel', {
      defaultMessage: 'Transform description'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    placeholder: _i18n.i18n.translate('xpack.transform.stepDetailsForm.transformDescriptionPlaceholderText', {
      defaultMessage: 'Description (optional)'
    }),
    value: transformDescription,
    onChange: e => setTransformDescription(e.target.value),
    "aria-label": _i18n.i18n.translate('xpack.transform.stepDetailsForm.transformDescriptionInputAriaLabel', {
      defaultMessage: 'Choose an optional transform description.'
    }),
    "data-test-subj": "transformDescriptionInput"
  })), /*#__PURE__*/_react.default.createElement(_destination_index_form.DestinationIndexForm, {
    createIndexLink: esIndicesCreateIndex,
    destinationIndex: destinationIndex,
    destinationIndexNameEmpty: indexNameEmpty,
    destinationIndexNameExists: indexNameExists,
    destinationIndexNameValid: indexNameValid,
    destIndexSameAsId: destIndexSameAsId,
    fullWidth: false,
    indexNameExistsMessage: _i18n.i18n.translate('xpack.transform.stepDetailsForm.destinationIndexHelpText', {
      defaultMessage: 'An index with this name already exists. Be aware that running this transform will modify this destination index.'
    }),
    isJobCreated: transformIdExists,
    onDestinationIndexChange: setDestinationIndex,
    setDestIndexSameAsId: setDestIndexSameAsId,
    switchLabel: _i18n.i18n.translate('xpack.transform.stepDetailsForm.destinationIndexFormSwitchLabel', {
      defaultMessage: 'Use transform ID as destination index name'
    })
  }), ingestPipelineNames.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.transform.stepDetailsForm.destinationIngestPipelineLabel', {
      defaultMessage: 'Destination ingest pipeline'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": "transformDestinationPipelineSelect",
    "aria-label": _i18n.i18n.translate('xpack.transform.stepDetailsForm.destinationIngestPipelineAriaLabel', {
      defaultMessage: 'Select an ingest pipeline (optional)'
    }),
    placeholder: _i18n.i18n.translate('xpack.transform.stepDetailsForm.destinationIngestPipelineComboBoxPlaceholder', {
      defaultMessage: 'Select an ingest pipeline (optional)'
    }),
    singleSelection: {
      asPlainText: true
    },
    options: ingestPipelineNames.map(label => ({
      label
    })),
    selectedOptions: destinationIngestPipeline !== '' ? [{
      label: destinationIngestPipeline
    }] : [],
    onChange: options => {
      var _options$0$label, _options$;
      return setDestinationIngestPipeline((_options$0$label = (_options$ = options[0]) === null || _options$ === void 0 ? void 0 : _options$.label) !== null && _options$0$label !== void 0 ? _options$0$label : '');
    }
  })), stepDefineState.transformFunction === _constants.TRANSFORM_FUNCTION.LATEST ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "warning",
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.transform.stepDetailsForm.destinationIndexWarning",
    defaultMessage: "Before you start the transform, use index templates or the {docsLink} to ensure the mappings for your destination index match the source index. Otherwise, the destination index is created with dynamic mappings. If the transform fails, check the messages tab on the Stack Management page for errors.",
    values: {
      docsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: esIndicesCreateIndex,
        target: "_blank"
      }, _i18n.i18n.translate('xpack.transform.stepDetailsForm.createIndexAPI', {
        defaultMessage: 'Create index API'
      }))
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm'
  })) : null, /*#__PURE__*/_react.default.createElement(_create_data_view_form_row.CreateDataViewForm, {
    canCreateDataView: canCreateDataView,
    createDataView: createDataView,
    dataViewTitleExists: dataViewTitleExists,
    setCreateDataView: setCreateDataView,
    dataViewAvailableTimeFields: destIndexAvailableTimeFields,
    dataViewTimeField: dataViewTimeField,
    onTimeFieldChanged: onTimeFieldChanged
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    helpText: isContinuousModeAvailable === false ? _i18n.i18n.translate('xpack.transform.stepDetailsForm.continuousModeError', {
      defaultMessage: 'Continuous mode is not available for indices without date fields.'
    }) : ''
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    name: "transformContinuousMode",
    label: _i18n.i18n.translate('xpack.transform.stepCreateForm.continuousModeLabel', {
      defaultMessage: 'Continuous mode'
    }),
    checked: isContinuousModeEnabled === true,
    onChange: () => setContinuousModeEnabled(!isContinuousModeEnabled),
    disabled: isContinuousModeAvailable === false,
    "data-test-subj": "transformContinuousModeSwitch"
  })), isContinuousModeEnabled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.transform.stepDetailsForm.continuousModeDateFieldLabel', {
      defaultMessage: 'Date field for continuous mode'
    }),
    helpText: _i18n.i18n.translate('xpack.transform.stepDetailsForm.continuousModeDateFieldHelpText', {
      defaultMessage: 'Select the date field that can be used to identify new documents.'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: sourceIndexDateFieldNames.map(text => ({
      text,
      value: text
    })),
    value: continuousModeDateField,
    onChange: e => setContinuousModeDateField(e.target.value),
    "data-test-subj": "transformContinuousDateFieldSelect"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.transform.stepDetailsForm.continuousModeDelayLabel', {
      defaultMessage: 'Delay'
    }),
    isInvalid: !isContinuousModeDelayValid,
    error: !isContinuousModeDelayValid && [_i18n.i18n.translate('xpack.transform.stepDetailsForm.continuousModeDelayError', {
      defaultMessage: 'Invalid delay format'
    })],
    helpText: _i18n.i18n.translate('xpack.transform.stepDetailsForm.continuousModeDelayHelpText', {
      defaultMessage: 'Time delay between current time and latest input data time.'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    placeholder: _i18n.i18n.translate('xpack.transform.stepDetailsForm.continuousModeDelayPlaceholderText', {
      defaultMessage: 'delay e.g. {exampleValue}',
      values: {
        exampleValue: '60s'
      }
    }),
    value: continuousModeDelay,
    onChange: e => setContinuousModeDelay(e.target.value),
    "aria-label": _i18n.i18n.translate('xpack.transform.stepDetailsForm.continuousModeAriaLabel', {
      defaultMessage: 'Choose a delay.'
    }),
    isInvalid: !isContinuousModeDelayValid,
    "data-test-subj": "transformContinuousDelayInput"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    helpText: isRetentionPolicyAvailable === false ? _i18n.i18n.translate('xpack.transform.stepDetailsForm.retentionPolicyError', {
      defaultMessage: 'Retention policy settings are not available for indices without date fields.'
    }) : ''
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    name: "transformRetentionPolicy",
    label: _i18n.i18n.translate('xpack.transform.stepCreateForm.retentionPolicyLabel', {
      defaultMessage: 'Retention policy'
    }),
    checked: isRetentionPolicyEnabled === true,
    onChange: () => setRetentionPolicyEnabled(!isRetentionPolicyEnabled),
    disabled: isRetentionPolicyAvailable === false,
    "data-test-subj": "transformRetentionPolicySwitch"
  })), isRetentionPolicyEnabled && isRetentionPolicyAvailable && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.transform.stepDetailsForm.retentionPolicyDateFieldLabel', {
      defaultMessage: 'Date field for retention policy'
    }),
    helpText: _i18n.i18n.translate('xpack.transform.stepDetailsForm.retentionPolicyDateFieldHelpText', {
      defaultMessage: 'Select the date field that can be used to identify out of date documents in the destination index.'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: destIndexAvailableTimeFields.map(text => ({
      text
    })),
    value: retentionPolicyDateField,
    onChange: e => setRetentionPolicyDateField(e.target.value),
    "data-test-subj": "transformRetentionPolicyDateFieldSelect"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.transform.stepDetailsForm.retentionPolicyMaxAgeLabel', {
      defaultMessage: 'Max age'
    }),
    isInvalid: !retentionPolicyMaxAgeEmpty && !isRetentionPolicyMaxAgeValid,
    error: !retentionPolicyMaxAgeEmpty && !isRetentionPolicyMaxAgeValid && [_messages.retentionPolicyMaxAgeInvalidErrorMessage],
    helpText: _i18n.i18n.translate('xpack.transform.stepDetailsForm.retentionPolicyMaxAgeHelpText', {
      defaultMessage: 'Documents that are older than the configured value will be removed from the destination index.'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    placeholder: _i18n.i18n.translate('xpack.transform.stepDetailsForm.retentionPolicyMaxAgePlaceholderText', {
      defaultMessage: 'max_age e.g. {exampleValue}',
      values: {
        exampleValue: '7d'
      }
    }),
    value: retentionPolicyMaxAge,
    onChange: e => setRetentionPolicyMaxAge(e.target.value),
    "aria-label": _i18n.i18n.translate('xpack.transform.stepDetailsForm.retentionPolicyMaxAgeAriaLabel', {
      defaultMessage: 'Choose a max age.'
    }),
    isInvalid: !retentionPolicyMaxAgeEmpty && !isRetentionPolicyMaxAgeValid,
    "data-test-subj": "transformRetentionPolicyMaxAgeInput"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    "data-test-subj": "transformWizardAccordionAdvancedSettings",
    id: "transformWizardAccordionAdvancedSettings",
    buttonContent: _i18n.i18n.translate('xpack.transform.stepDetailsForm.advancedSettingsAccordionButtonContent', {
      defaultMessage: 'Advanced settings'
    }),
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.transform.stepDetailsForm.frequencyLabel', {
      defaultMessage: 'Frequency'
    }),
    isInvalid: !isTransformFrequencyValid,
    error: !isTransformFrequencyValid && [_i18n.i18n.translate('xpack.transform.stepDetailsForm.frequencyError', {
      defaultMessage: 'Invalid frequency format'
    })],
    helpText: _i18n.i18n.translate('xpack.transform.stepDetailsForm.frequencyHelpText', {
      defaultMessage: 'The interval to check for changes in source indices when the transform runs continuously.'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    placeholder: _i18n.i18n.translate('xpack.transform.stepDetailsForm.editFlyoutFormFrequencyPlaceholderText', {
      defaultMessage: 'Default: {defaultValue}',
      values: {
        defaultValue: _constants.DEFAULT_TRANSFORM_FREQUENCY
      }
    }),
    value: transformFrequency,
    onChange: e => setTransformFrequency(e.target.value),
    "aria-label": _i18n.i18n.translate('xpack.transform.stepDetailsForm.frequencyAriaLabel', {
      defaultMessage: 'Choose a frequency.'
    }),
    isInvalid: !isTransformFrequencyValid,
    "data-test-subj": "transformFrequencyInput"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.transform.stepDetailsForm.maxPageSearchSizeLabel', {
      defaultMessage: 'Maximum page search size'
    }),
    isInvalid: !isTransformSettingsMaxPageSearchSizeValid,
    error: transformSettingsMaxPageSearchSizeErrors,
    helpText: _i18n.i18n.translate('xpack.transform.stepDetailsForm.maxPageSearchSizeHelpText', {
      defaultMessage: 'The initial page size to use for the composite aggregation for each checkpoint.'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    placeholder: _i18n.i18n.translate('xpack.transform.stepDetailsForm.editFlyoutFormMaxPageSearchSizePlaceholderText', {
      defaultMessage: 'Default: {defaultValue}',
      values: {
        defaultValue: 500
      }
    }),
    value: transformSettingsMaxPageSearchSize ? transformSettingsMaxPageSearchSize.toString() : transformSettingsMaxPageSearchSize,
    onChange: e => {
      if (e.target.value !== '') {
        const parsed = parseInt(e.target.value, 10);
        setTransformSettingsMaxPageSearchSize(isFinite(parsed) ? parsed : undefined);
      } else {
        setTransformSettingsMaxPageSearchSize(undefined);
      }
    },
    "aria-label": _i18n.i18n.translate('xpack.transform.stepDetailsForm.maxPageSearchSizeAriaLabel', {
      defaultMessage: 'Choose a maximum page search size.'
    }),
    isInvalid: !isTransformSettingsMaxPageSearchSizeValid,
    "data-test-subj": "transformMaxPageSearchSizeInput"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "transformNumFailureRetriesFormRow",
    label: _i18n.i18n.translate('xpack.transform.stepDetailsForm.transformNumFailureRetriesLabel', {
      defaultMessage: 'Number of failure retries'
    }),
    isInvalid: !isTransformSettingsNumFailureRetriesValid,
    error: !isTransformSettingsNumFailureRetriesValid && [_i18n.i18n.translate('xpack.transform.stepDetailsForm.NumFailureRetriesError', {
      defaultMessage: 'Number of retries needs to be between 0 and 100, or -1 for infinite retries.'
    })],
    helpText: _i18n.i18n.translate('xpack.transform.stepDetailsForm.transformNumRetriesHelpText', {
      defaultMessage: 'The number of retries on a recoverable failure before the transform task is marked as failed. Set it to -1 for infinite retries.'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: transformSettingsNumFailureRetries || transformSettingsNumFailureRetries !== undefined && Number(transformSettingsNumFailureRetries) >= -1 ? transformSettingsNumFailureRetries.toString() : '',
    onChange: e => {
      if (e.target.value === '') {
        setTransformSettingsNumFailureRetries(undefined);
        return;
      }
      setTransformSettingsNumFailureRetries(e.target.value === '-' ? '-' : parseInt(e.target.value, 10));
    },
    "aria-label": _i18n.i18n.translate('xpack.transform.stepDetailsForm.numFailureRetriesAriaLabel', {
      defaultMessage: 'Choose a maximum number of retries.'
    }),
    isInvalid: !isTransformSettingsNumFailureRetriesValid,
    "data-test-subj": "transformNumFailureRetriesInput"
  })))));
});