"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stringNotValidErrorMessage = exports.retentionPolicyMaxAgeInvalidErrorMessage = exports.requiredErrorMessage = exports.frequencyNotValidErrorMessage = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Retention policy max age validator
const retentionPolicyMaxAgeInvalidErrorMessage = exports.retentionPolicyMaxAgeInvalidErrorMessage = _i18n.i18n.translate('xpack.transform.transformSettingValidations.retentionPolicyMaxAgeInvalidMessage', {
  defaultMessage: 'Invalid max age format. Minimum of 60s required.'
});
const requiredErrorMessage = exports.requiredErrorMessage = _i18n.i18n.translate('xpack.transform.transformList.editFlyoutFormRequiredErrorMessage', {
  defaultMessage: 'Required field.'
});
const stringNotValidErrorMessage = exports.stringNotValidErrorMessage = _i18n.i18n.translate('xpack.transform.transformList.editFlyoutFormStringNotValidErrorMessage', {
  defaultMessage: 'Value needs to be of type string.'
});
const frequencyNotValidErrorMessage = exports.frequencyNotValidErrorMessage = _i18n.i18n.translate('xpack.transform.transformList.editFlyoutFormFrequencyNotValidErrorMessage', {
  defaultMessage: 'The frequency value is not valid.'
});