"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatTimelineData = void 0;
var _fp = require("lodash/fp");
var _to_array = require("../../../../../common/utils/to_array");
var _field_formatters = require("../../../../../common/utils/field_formatters");
var _get_timestamp = require("./get_timestamp");
var _get_nested_parent_path = require("./get_nested_parent_path");
var _build_object_recursive = require("./build_object_recursive");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createBaseTimelineEdges = () => ({
  node: {
    ecs: {
      _id: ''
    },
    data: [],
    _id: '',
    _index: ''
  },
  cursor: {
    value: '',
    tiebreaker: null
  }
});
function deepMerge(target, source) {
  for (const key in source) {
    if (!Object.prototype.hasOwnProperty.call(source, key) || key === '__proto__' || key === 'constructor')
      // eslint-disable-next-line no-continue
      continue;
    if (source[key] instanceof Object && target[key] instanceof Object) {
      deepMerge(target[key], source[key]);
    } else {
      target[key] = source[key];
    }
  }
  return target;
}
const processMetadataField = (fieldName, hit) => [{
  field: fieldName,
  value: (0, _to_array.toStringArray)((0, _fp.get)(fieldName, hit))
}];
const processFieldData = (fieldName, hit, nestedParentFieldName) => {
  const fieldToEval = nestedParentFieldName ? {
    [nestedParentFieldName]: hit.fields[nestedParentFieldName]
  } : {
    [fieldName]: hit.fields[fieldName]
  };
  const formattedData = (0, _field_formatters.getDataFromFieldsHits)(fieldToEval);
  const fieldsData = [];
  return formattedData.reduce((agg, {
    field,
    values
  }) => {
    if (field.includes(fieldName)) {
      agg.push({
        field,
        value: values
      });
    }
    return agg;
  }, fieldsData);
};
const formatTimelineData = async (hits, fieldRequested, excludeEcsData) => {
  const ecsFields = excludeEcsData ? [] : _constants.TIMELINE_EVENTS_FIELDS;
  const uniqueFields = new Set([...ecsFields, ...fieldRequested]);
  const dataFieldSet = new Set(fieldRequested);
  const ecsFieldSet = new Set(ecsFields);
  const results = new Array(hits.length);
  for (let i = 0; i < hits.length; i++) {
    const hit = hits[i];
    if (hit._id) {
      var _hit$sort;
      const result = createBaseTimelineEdges();
      result.node._id = hit._id;
      result.node._index = hit._index;
      result.node.ecs._id = hit._id;
      result.node.ecs.timestamp = (0, _get_timestamp.getTimestamp)(hit);
      result.node.ecs._index = hit._index;
      if (((_hit$sort = hit.sort) === null || _hit$sort === void 0 ? void 0 : _hit$sort.length) > 1) {
        result.cursor.value = hit.sort[0];
        result.cursor.tiebreaker = hit.sort[1];
      }
      result.node.data = [];
      const hitFieldKeys = Object.keys(hit.fields || {});
      for (const fieldName of uniqueFields) {
        const nestedParentPath = (0, _get_nested_parent_path.getNestedParentPath)(fieldName, hitFieldKeys);
        const isEcs = _constants.ECS_METADATA_FIELDS.includes(fieldName);
        if (!nestedParentPath && !(0, _fp.has)(fieldName, hit.fields) && !isEcs) {
          // eslint-disable-next-line no-continue
          continue;
        }
        if (dataFieldSet.has(fieldName)) {
          const values = isEcs ? processMetadataField(fieldName, hit) : processFieldData(fieldName, hit, nestedParentPath);
          result.node.data.push(...values);
        }
        if (ecsFieldSet.has(fieldName)) {
          deepMerge(result.node.ecs, (0, _build_object_recursive.buildObjectRecursive)(fieldName, hit.fields, hitFieldKeys));
        }
      }
      results[i] = result;
    } else {
      results[i] = createBaseTimelineEdges();
    }
  }
  return results;
};
exports.formatTimelineData = formatTimelineData;