"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatSyntheticsPolicy = void 0;
var _lodash = require("lodash");
var _processors_formatter = require("./processors_formatter");
var _monitor_management = require("../../../../common/constants/monitor_management");
var _runtime_types = require("../../../../common/runtime_types");
var _browser_formatters = require("./browser_formatters");
var _formatting_utils = require("../formatting_utils");
var _formatters = require("./formatters");
var _common = require("../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formatSyntheticsPolicy = (newPolicy, monitorType, config, params, mws, isLegacy) => {
  var _dataStream$vars2, _dataStream$vars3, _config$ConfigKey$MAI, _dataStream$vars4;
  const configKeys = Object.keys(config);
  const formattedPolicy = (0, _lodash.cloneDeep)(newPolicy);
  const currentInput = formattedPolicy.inputs.find(input => input.type === `synthetics/${monitorType}`);
  const dataStream = currentInput === null || currentInput === void 0 ? void 0 : currentInput.streams.find(stream => stream.data_stream.dataset === monitorType);
  formattedPolicy.inputs.forEach(input => input.enabled = false);
  if (currentInput && dataStream) {
    // reset all data streams to enabled false
    formattedPolicy.inputs.forEach(input => input.enabled = false);
    // enable only the input type and data stream that matches the monitor type.
    currentInput.enabled = true;
    dataStream.enabled = true;
  }
  configKeys.forEach(key => {
    var _dataStream$vars;
    const configItem = dataStream === null || dataStream === void 0 ? void 0 : (_dataStream$vars = dataStream.vars) === null || _dataStream$vars === void 0 ? void 0 : _dataStream$vars[key];
    if (configItem) {
      if (_formatters.syntheticsPolicyFormatters[key]) {
        var _syntheticsPolicyForm;
        configItem.value = (_syntheticsPolicyForm = _formatters.syntheticsPolicyFormatters[key]) === null || _syntheticsPolicyForm === void 0 ? void 0 : _syntheticsPolicyForm.call(_formatters.syntheticsPolicyFormatters, config, key);
      } else if (key === _runtime_types.ConfigKey.MONITOR_SOURCE_TYPE && isLegacy) {
        configItem.value = undefined;
      } else {
        configItem.value = config[key] === undefined || config[key] === null ? null : config[key];
      }
      if (!_common.PARAMS_KEYS_TO_SKIP.includes(key)) {
        configItem.value = (0, _formatting_utils.replaceStringWithParams)(configItem.value, params);
      }
      // if value contains a new line we need to add extra \n to escape it
      if (typeof configItem.value === 'string' && configItem.value.includes('\n')) {
        configItem.value = (0, _formatting_utils.handleMultilineStringFormatter)(configItem.value);
      }
    }
  });
  const processorItem = dataStream === null || dataStream === void 0 ? void 0 : (_dataStream$vars2 = dataStream.vars) === null || _dataStream$vars2 === void 0 ? void 0 : _dataStream$vars2.processors;
  if (processorItem) {
    processorItem.value = (0, _processors_formatter.processorsFormatter)(config);
  }
  const mwItem = dataStream === null || dataStream === void 0 ? void 0 : (_dataStream$vars3 = dataStream.vars) === null || _dataStream$vars3 === void 0 ? void 0 : _dataStream$vars3[_runtime_types.ConfigKey.MAINTENANCE_WINDOWS];
  if ((_config$ConfigKey$MAI = config[_runtime_types.ConfigKey.MAINTENANCE_WINDOWS]) !== null && _config$ConfigKey$MAI !== void 0 && _config$ConfigKey$MAI.length && mwItem) {
    const maintenanceWindows = config[_runtime_types.ConfigKey.MAINTENANCE_WINDOWS];
    const formattedVal = (0, _formatting_utils.formatMWs)(maintenanceWindows.map(window => {
      if (typeof window === 'string') {
        return mws.find(m => m.id === window);
      }
      return window;
    }));
    if (formattedVal) {
      mwItem.value = formattedVal;
    }
  }

  // TODO: remove this once we remove legacy support
  const throttling = dataStream === null || dataStream === void 0 ? void 0 : (_dataStream$vars4 = dataStream.vars) === null || _dataStream$vars4 === void 0 ? void 0 : _dataStream$vars4[_monitor_management.LegacyConfigKey.THROTTLING_CONFIG];
  if (throttling) {
    throttling.value = _browser_formatters.throttlingFormatter === null || _browser_formatters.throttlingFormatter === void 0 ? void 0 : (0, _browser_formatters.throttlingFormatter)(config, _runtime_types.ConfigKey.THROTTLING_CONFIG);
  }
  return {
    formattedPolicy,
    hasDataStream: Boolean(dataStream),
    hasInput: Boolean(currentInput)
  };
};
exports.formatSyntheticsPolicy = formatSyntheticsPolicy;