"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectorTypesRoute = void 0;
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getConnectorTypesRoute = () => ({
  method: 'GET',
  path: _constants.SYNTHETICS_API_URLS.GET_CONNECTOR_TYPES,
  validate: {},
  handler: async ({
    context,
    server,
    savedObjectsClient
  }) => {
    var _await$context$action;
    const actionsClient = (_await$context$action = await context.actions) === null || _await$context$action === void 0 ? void 0 : _await$context$action.getActionsClient();
    return actionsClient.listTypes({
      featureId: 'uptime'
    });
  }
});
exports.getConnectorTypesRoute = getConnectorTypesRoute;