"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.privateLocationsStateReducer = void 0;
var _toolkit = require("@reduxjs/toolkit");
var _actions = require("./actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = {
  data: null,
  loading: false,
  error: null,
  isManageFlyoutOpen: false,
  isPrivateLocationFlyoutVisible: false,
  createLoading: false,
  editLoading: false,
  privateLocationToEdit: undefined
};
const privateLocationsStateReducer = exports.privateLocationsStateReducer = (0, _toolkit.createReducer)(initialState, builder => {
  builder.addCase(_actions.getPrivateLocationsAction.get, state => {
    state.loading = true;
  }).addCase(_actions.getPrivateLocationsAction.success, (state, action) => {
    state.data = action.payload;
    state.loading = false;
  }).addCase(_actions.getPrivateLocationsAction.fail, (state, action) => {
    state.error = action.payload;
    state.loading = false;
  }).addCase(_actions.createPrivateLocationAction.get, state => {
    state.createLoading = true;
  }).addCase(_actions.createPrivateLocationAction.success, (state, action) => {
    state.newLocation = action.payload;
    state.createLoading = false;
    state.data = null;
    state.isPrivateLocationFlyoutVisible = false;
  }).addCase(_actions.createPrivateLocationAction.fail, (state, action) => {
    state.error = action.payload;
    state.createLoading = false;
  }).addCase(_actions.editPrivateLocationAction.get, state => {
    state.editLoading = true;
  }).addCase(_actions.editPrivateLocationAction.success, (state, action) => {
    state.editLoading = false;
    state.privateLocationToEdit = undefined;
    state.data = null;
    state.isPrivateLocationFlyoutVisible = false;
  }).addCase(_actions.editPrivateLocationAction.fail, (state, action) => {
    state.editLoading = false;
    state.privateLocationToEdit = undefined;
    state.error = action.payload;
  }).addCase(_actions.deletePrivateLocationAction.get, state => {
    state.deleteLoading = true;
  }).addCase(_actions.deletePrivateLocationAction.success, (state, action) => {
    state.deleteLoading = false;
    state.data = null;
  }).addCase(_actions.deletePrivateLocationAction.fail, (state, action) => {
    state.error = action.payload;
    state.deleteLoading = false;
  }).addCase(_actions.setIsPrivateLocationFlyoutVisible, (state, action) => {
    state.isPrivateLocationFlyoutVisible = action.payload;
  }).addCase(_actions.setPrivateLocationToEdit, (state, action) => {
    state.privateLocationToEdit = action.payload;
  });
});