"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTickTick = useTickTick;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useTickTick(interval) {
  const [nextTick, setNextTick] = (0, _react.useState)(Date.now());
  const [tickTick] = (0, _react.useState)(() => setInterval(() => {
    setNextTick(Date.now());
  }, interval !== null && interval !== void 0 ? interval : 5 * 1000));
  const clear = (0, _react.useCallback)(() => {
    clearInterval(tickTick);
  }, [tickTick]);
  (0, _react.useEffect)(() => {
    return () => {
      clear();
    };
  }, [clear]);
  return {
    refreshTimer: tickTick,
    lastRefresh: nextTick,
    clearTicks: clear
  };
}