"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Sidebar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("./constants");
var _waterfall_context = require("./context/waterfall_context");
var _styles = require("./styles");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Sidebar = ({
  items,
  render
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    onSidebarClick
  } = (0, _waterfall_context.useWaterfallContext)();
  const handleSidebarClick = (0, _react.useMemo)(() => onSidebarClick, [onSidebarClick]);
  return /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartSidebarWrapper, {
    grow: _constants.SIDEBAR_GROW_SIZE
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      height: items.length * _constants.FIXED_AXIS_HEIGHT,
      overflow: 'hidden'
    },
    "data-test-subj": "wfSidebarContainer"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    css: {
      height: '100%'
    },
    hasBorder: false,
    hasShadow: false,
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: {
      height: '100%',
      paddingTop: 1.5
    },
    direction: "column",
    gutterSize: "none",
    responsive: false
  }, items.map((item, index) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: index,
      css: {
        outline: 0,
        minWidth: 0,
        // Needed for flex to not stretch noWrap children
        justifyContent: 'space-around',
        paddingRight: euiTheme.size.s
      }
    }, render(item, index, handleSidebarClick));
  })))));
};
exports.Sidebar = Sidebar;