"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteLocation = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _contexts = require("../../../contexts");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeleteLocation = ({
  loading,
  id,
  label,
  locationMonitors,
  onDelete
}) => {
  var _locationMonitors$fin, _locationMonitors$fin2;
  const monCount = (_locationMonitors$fin = locationMonitors === null || locationMonitors === void 0 ? void 0 : (_locationMonitors$fin2 = locationMonitors.find(l => l.id === id)) === null || _locationMonitors$fin2 === void 0 ? void 0 : _locationMonitors$fin2.count) !== null && _locationMonitors$fin !== void 0 ? _locationMonitors$fin : 0;
  const canDelete = monCount === 0;
  const {
    canSave
  } = (0, _contexts.useSyntheticsSettingsContext)();
  const [isModalOpen, setIsModalOpen] = (0, _react.useState)(false);
  const deleteDisabledReason = _i18n.i18n.translate('xpack.synthetics.monitorManagement.cannotDelete.description', {
    defaultMessage: `You can't delete this location because it is used in {monCount, number} {monCount, plural,one {monitor} other {monitors}}.
                Remove all monitors from this location first.`,
    values: {
      monCount
    }
  });
  const confirmModalTitleId = (0, _eui.useGeneratedHtmlId)();
  const deleteModal = /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": confirmModalTitleId,
    title: _i18n.i18n.translate('xpack.synthetics.monitorManagement.deleteLocationName', {
      defaultMessage: 'Delete "{location}"',
      values: {
        location: label
      }
    }),
    titleProps: {
      id: confirmModalTitleId
    },
    onCancel: () => setIsModalOpen(false),
    onConfirm: () => onDelete(id),
    cancelButtonText: CANCEL_LABEL,
    confirmButtonText: CONFIRM_LABEL,
    buttonColor: "danger",
    defaultFocusedButton: "confirm",
    isLoading: loading
  }, /*#__PURE__*/_react.default.createElement("p", null, ARE_YOU_SURE_LABEL));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isModalOpen && deleteModal, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: canDelete ? DELETE_LABEL : deleteDisabledReason
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": `deleteLocation-${id}`,
    isLoading: loading,
    iconType: "trash",
    color: "danger",
    "aria-label": DELETE_LABEL,
    onClick: () => {
      setIsModalOpen(true);
    },
    isDisabled: !canDelete || !canSave
  })));
};
exports.DeleteLocation = DeleteLocation;
const DELETE_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.deleteLocation', {
  defaultMessage: 'Delete location'
});
const CONFIRM_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.deleteLocationLabel', {
  defaultMessage: 'Delete location'
});
const CANCEL_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.cancelLabel', {
  defaultMessage: 'Cancel'
});
const ARE_YOU_SURE_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.areYouSure', {
  defaultMessage: 'Are you sure you want to delete this location?'
});