"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddOrEditLocationFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/security-plugin/public");
var _reactRedux = require("react-redux");
var _permissions = require("../../common/components/permissions");
var _contexts = require("../../../contexts");
var _use_form_wrapped = require("../../../../../hooks/use_form_wrapped");
var _location_form = require("./location_form");
var _manage_empty_state = require("./manage_empty_state");
var _selectors = require("../../../state/private_locations/selectors");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEmptyFunctionComponent = ({
  children
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
const AddOrEditLocationFlyout = ({
  onSubmit,
  onCloseFlyout,
  privateLocations,
  privateLocationToEdit
}) => {
  const form = (0, _use_form_wrapped.useFormWrapped)({
    mode: 'onSubmit',
    reValidateMode: 'onChange',
    shouldFocusError: true,
    defaultValues: privateLocationToEdit || {
      label: '',
      agentPolicyId: '',
      geo: {
        lat: 0,
        lon: 0
      },
      spaces: [_public2.ALL_SPACES_ID]
    }
  });
  const {
    canSave,
    canManagePrivateLocations
  } = (0, _contexts.useSyntheticsSettingsContext)();
  const {
    createLoading,
    editLoading
  } = (0, _reactRedux.useSelector)(_selectors.selectPrivateLocationsState);
  const {
    spaces: spacesApi
  } = (0, _public.useKibana)().services;
  const ContextWrapper = (0, _react.useMemo)(() => spacesApi ? spacesApi.ui.components.getSpacesContextProvider : getEmptyFunctionComponent, [spacesApi]);
  const {
    handleSubmit
  } = form;
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(ContextWrapper, null, /*#__PURE__*/_react.default.createElement(_reactHookForm.FormProvider, form, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onCloseFlyout,
    css: {
      width: 540
    },
    "aria-labelledby": flyoutTitleId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: flyoutTitleId
  }, privateLocationToEdit !== undefined ? EDIT_PRIVATE_LOCATION : ADD_PRIVATE_LOCATION))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_manage_empty_state.ManageEmptyState, {
    privateLocations: privateLocations,
    showEmptyLocations: false
  }, /*#__PURE__*/_react.default.createElement(_location_form.LocationForm, {
    privateLocations: privateLocations,
    privateLocationToEdit: privateLocationToEdit
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsLocationFlyoutCancelButton",
    iconType: "cross",
    onClick: onCloseFlyout,
    flush: "left",
    isLoading: createLoading || editLoading
  }, CANCEL_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_permissions.NoPermissionsTooltip, {
    canEditSynthetics: canSave
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "syntheticsLocationFlyoutSaveButton",
    fill: true,
    onClick: handleSubmit(onSubmit),
    isLoading: createLoading || editLoading,
    isDisabled: !canSave || !canManagePrivateLocations
  }, SAVE_LABEL))))))));
};
exports.AddOrEditLocationFlyout = AddOrEditLocationFlyout;
const ADD_PRIVATE_LOCATION = _i18n.i18n.translate('xpack.synthetics.monitorManagement.createPrivateLocations', {
  defaultMessage: 'Create private location'
});
const EDIT_PRIVATE_LOCATION = _i18n.i18n.translate('xpack.synthetics.monitorManagement.editPrivateLocations', {
  defaultMessage: 'Edit private location'
});
const CANCEL_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.cancelLabel', {
  defaultMessage: 'Cancel'
});
const SAVE_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.saveLabel', {
  defaultMessage: 'Save'
});