"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ParamValueField = exports.NEW_VALUE_LABEL = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _i18n = require("@kbn/i18n");
var _optional_text = require("../components/optional_text");
var _add_param_form = require("./add_param_form");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ParamValueField = ({
  isEditingItem
}) => {
  var _errors$value2;
  const {
    register
  } = (0, _reactHookForm.useFormContext)();
  const {
    errors
  } = (0, _reactHookForm.useFormState)();
  if (isEditingItem) {
    var _errors$value;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      label: NEW_VALUE_LABEL,
      isInvalid: Boolean(errors === null || errors === void 0 ? void 0 : errors.value),
      error: errors === null || errors === void 0 ? void 0 : (_errors$value = errors.value) === null || _errors$value === void 0 ? void 0 : _errors$value.message,
      labelAppend: /*#__PURE__*/_react.default.createElement(_optional_text.OptionalText, null)
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, (0, _extends2.default)({
      isInvalid: Boolean(errors === null || errors === void 0 ? void 0 : errors.value),
      "data-test-subj": "syntheticsAddParamFormTextArea",
      fullWidth: true,
      "aria-label": NEW_VALUE_LABEL
    }, register('value')))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      size: "s",
      title: _i18n.i18n.translate('xpack.synthetics.paramValueField.euiCallOut.newValue', {
        defaultMessage: 'Assign a new value to update this parameter, or leave blank to keep the current value.'
      }),
      iconType: "info"
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _add_param_form.VALUE_LABEL,
    isInvalid: Boolean(errors === null || errors === void 0 ? void 0 : errors.value),
    error: errors === null || errors === void 0 ? void 0 : (_errors$value2 = errors.value) === null || _errors$value2 === void 0 ? void 0 : _errors$value2.message
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, (0, _extends2.default)({
    isInvalid: Boolean(errors === null || errors === void 0 ? void 0 : errors.value),
    "data-test-subj": "syntheticsAddParamFormTextArea",
    fullWidth: true,
    "aria-label": _add_param_form.VALUE_LABEL
  }, register('value', {
    required: {
      value: true,
      message: _add_param_form.VALUE_REQUIRED
    }
  }))));
};
exports.ParamValueField = ParamValueField;
const NEW_VALUE_LABEL = exports.NEW_VALUE_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.paramForm.newValue', {
  defaultMessage: 'New value'
});